/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.authentication;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugins.rest.api.security.exception.AuthenticationRequiredException;
import com.atlassian.plugins.rest.api.security.exception.AuthorizationException;
import com.atlassian.plugins.rest.v2.security.authentication.AccessType;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
@Provider
public class AuthenticatedResourceFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedResourceFilter.class);
    public static final String DEFAULT_TO_LICENSED_ACCESS_DISABLED_FEATURE_KEY = "atlassian.rest.default.to.licensed.access.disabled";
    public static final String DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY = "atlassian.rest.default.to.sysadmin.access.enabled";
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;
    private final ScopesRequestCache scopesRequestCache;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest request;

    public AuthenticatedResourceFilter(UserManager userManager, DarkFeatureManager darkFeatureManager, ScopesRequestCache scopesRequestCache) {
        this.userManager = userManager;
        this.darkFeatureManager = darkFeatureManager;
        this.scopesRequestCache = scopesRequestCache;
    }

    public void filter(ContainerRequestContext requestContext) {
        boolean is3LO;
        UserKey userKey = this.userManager.getRemoteUserKey();
        boolean isAnonymous = userKey == null;
        boolean isOAuth2 = this.request.getAttribute("oauth2.token.client_configuration_id") != null;
        boolean isServiceAccount = this.request.getAttribute("serviceAccount") != null;
        boolean is2LO = isOAuth2 && (isServiceAccount || isAnonymous);
        boolean bl = is3LO = isOAuth2 && !is2LO;
        if (!isOAuth2) {
            this.requireAccessGrantedByAccessType(userKey);
        } else if (is3LO) {
            this.requireAccessGrantedByAccessType(userKey);
            this.requireAccessGrantedByOAuth2Scopes_3LO();
        } else {
            this.requireAccessGrantedByOAuth2Scopes_2LO();
        }
    }

    void requireAccessGrantedByAccessType(UserKey userKey) {
        AccessType requiredAccessType = this.getRequiredAccessType();
        boolean isGranted = this.grantAccessBySecurityAnnotations(requiredAccessType);
        if (!isGranted) {
            throw AuthenticatedResourceFilter.mapToException(userKey, requiredAccessType);
        }
    }

    void requireAccessGrantedByOAuth2Scopes_3LO() {
        String[] resourceScopes = AuthenticatedResourceFilter.getScopesRequiredForResource(this.resourceInfo);
        Set scopeApplicableFor3LO = Arrays.stream(resourceScopes).filter(arg_0 -> ((ScopesRequestCache)this.scopesRequestCache).isScopeApplicableFor3LO(arg_0)).collect(Collectors.toSet());
        if (resourceScopes.length > 0) {
            if (scopeApplicableFor3LO.isEmpty()) {
                throw new AuthorizationException("This resource is not allowed for 3LO access.");
            }
            boolean isOAuth2ScopesGranted = this.scopesRequestCache.requestHasGrantsForAny(scopeApplicableFor3LO);
            if (!isOAuth2ScopesGranted) {
                throw AuthenticatedResourceFilter.mapToException(resourceScopes);
            }
        }
    }

    void requireAccessGrantedByOAuth2Scopes_2LO() {
        String[] resourceScopes = AuthenticatedResourceFilter.getScopesRequiredForResource(this.resourceInfo);
        Set scopeApplicableFor2LO = Arrays.stream(resourceScopes).filter(arg_0 -> ((ScopesRequestCache)this.scopesRequestCache).isScopeApplicableFor2LO(arg_0)).collect(Collectors.toSet());
        if (scopeApplicableFor2LO.isEmpty()) {
            throw new AuthorizationException("This resource is not allowed for 2LO access.");
        }
        boolean isOAuth2ScopesGranted = this.scopesRequestCache.requestHasGrantsForAny(scopeApplicableFor2LO);
        if (!isOAuth2ScopesGranted) {
            throw AuthenticatedResourceFilter.mapToException(resourceScopes);
        }
    }

    private boolean grantAccessBySecurityAnnotations(AccessType requiredAccessType) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        return switch (requiredAccessType) {
            case AccessType.SYSTEM_ADMIN_ONLY -> this.userManager.isSystemAdmin(userKey);
            case AccessType.ADMIN_ONLY -> {
                if (this.userManager.isAdmin(userKey) || this.userManager.isSystemAdmin(userKey)) {
                    yield true;
                }
                yield false;
            }
            case AccessType.LICENSED_ONLY -> this.userManager.isLicensed(userKey);
            case AccessType.UNLICENSED_SITE_ACCESS -> {
                if (this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey)) {
                    yield true;
                }
                yield false;
            }
            case AccessType.ANONYMOUS_SITE_ACCESS -> {
                boolean isLicensedAllowed;
                boolean isAnonymous = userKey == null;
                boolean isAnonymousAllowed = isAnonymous && this.userManager.isAnonymousAccessEnabled();
                boolean v1 = isLicensedAllowed = this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey);
                if (isAnonymousAllowed || isLicensedAllowed) {
                    yield true;
                }
                yield false;
            }
            default -> AccessType.UNRESTRICTED_ACCESS == requiredAccessType;
        };
    }

    private AccessType getRequiredAccessType() {
        AccessType accessType = AccessType.getAccessType(this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod());
        if (AccessType.EMPTY == accessType) {
            accessType = this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY).orElse(false) != false ? AccessType.SYSTEM_ADMIN_ONLY : (this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_LICENSED_ACCESS_DISABLED_FEATURE_KEY).orElse(false) != false ? AccessType.UNRESTRICTED_ACCESS : AccessType.LICENSED_ONLY);
        }
        return accessType;
    }

    private static String[] getScopesRequiredForResource(ResourceInfo resourceInfo) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        Optional<ScopesAllowed> scopesAllowedAnnotation = Stream.of(resourceMethod).filter(Objects::nonNull).map(annotatedElement -> annotatedElement.getAnnotation(ScopesAllowed.class)).filter(Objects::nonNull).findFirst();
        if (scopesAllowedAnnotation.isPresent()) {
            return scopesAllowedAnnotation.get().requiredScope();
        }
        Optional<Annotation> annotationFromDifferentClassLoader = Stream.of(resourceMethod).filter(Objects::nonNull).flatMap(annotatedElement -> Arrays.stream(annotatedElement.getAnnotations())).filter((? super T annotation) -> annotation.annotationType().getName().equals(ScopesAllowed.class.getName())).findFirst();
        if (annotationFromDifferentClassLoader.isPresent()) {
            Class resourceClass = resourceInfo.getResourceClass();
            log.error("Resource class={} method={} has ScopesAllowed annotation from a different class loader, ignoring it. Please ensure that atlassian-annotations dependency is added with a provided scope in the plugin's pom.xml", (Object)resourceClass, (Object)resourceMethod);
        }
        return new String[0];
    }

    private static SecurityException mapToException(String[] requiredScopes) {
        String message = String.format("Client must have sufficient scopes to access this resource. Required scopes: %s", Arrays.toString(requiredScopes));
        log.debug(message);
        return new AuthorizationException(message);
    }

    private static SecurityException mapToException(UserKey userKey, AccessType accessType) {
        if (userKey == null) {
            return new AuthenticationRequiredException();
        }
        if (accessType == AccessType.SYSTEM_ADMIN_ONLY) {
            return new AuthorizationException("Client must be authenticated as a system administrator to access this resource.");
        }
        if (accessType == AccessType.ADMIN_ONLY) {
            return new AuthorizationException("Client must be authenticated as an administrator to access this resource.");
        }
        if (accessType == AccessType.LICENSED_ONLY) {
            throw new AuthorizationException("Client must be authenticated as a licensed user to access this resource.");
        }
        return new AuthorizationException("Client must have sufficient permissions to access this resource.");
    }
}

