/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.multipart.fileupload;

import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartForm;
import com.atlassian.plugins.rest.api.multipart.MultipartHandler;
import com.atlassian.plugins.rest.v2.multipart.exception.FileCountLimitExceededException;
import com.atlassian.plugins.rest.v2.multipart.exception.FileSizeLimitExceededException;
import com.atlassian.plugins.rest.v2.multipart.fileupload.CommonsFileUploadFilePart;
import io.atlassian.util.concurrent.Lazy;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletRequestContext;

public class CommonsFileUploadMultipartHandler
implements MultipartHandler {
    public static final long NO_LIMIT = -1L;
    public static final long DEFAULT_REQUEST_PART_LIMIT = 1000L;
    private final JakartaServletFileUpload servletFileUpload = new JakartaServletFileUpload((FileItemFactory)new DiskFileItemFactory.Builder().get());

    public CommonsFileUploadMultipartHandler() {
        this(-1L, -1L, 1000L);
    }

    public CommonsFileUploadMultipartHandler(long maxFileSize, long maxSize, long maxFileCount) {
        this.servletFileUpload.setFileSizeMax(maxFileSize);
        this.servletFileUpload.setSizeMax(maxSize);
        this.servletFileUpload.setFileCountMax(maxFileCount);
    }

    public FilePart getFilePart(HttpServletRequest request, String field) {
        return this.getForm(request).getFilePart(field);
    }

    public MultipartForm getForm(HttpServletRequest request) {
        return this.getForm((RequestContext)new JakartaServletRequestContext(request));
    }

    public MultipartForm getForm(RequestContext request) {
        try {
            return new CommonsFileUploadMultipartForm(this.servletFileUpload.parseRequest(request));
        }
        catch (FileUploadException e) {
            if (e instanceof FileUploadFileCountLimitException) {
                throw new FileCountLimitExceededException(e.getMessage());
            }
            if (e instanceof FileUploadSizeException) {
                throw new FileSizeLimitExceededException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    private static class CommonsFileUploadMultipartForm
    implements MultipartForm {
        private final Collection<FileItem> fileItems;
        private final Supplier<Set<String>> fieldNames;

        private CommonsFileUploadMultipartForm(Collection<FileItem> fileItems) {
            this.fileItems = fileItems;
            this.fieldNames = Lazy.supplier(() -> fileItems.stream().map(FileItem::getFieldName).collect(Collectors.toUnmodifiableSet()));
        }

        private Stream<FilePart> getFilePartsStream(String field) {
            return this.fileItems.stream().filter(item -> item.getFieldName().equals(field)).map(CommonsFileUploadFilePart::new);
        }

        public FilePart getFilePart(String field) {
            return this.getFilePartsStream(field).findFirst().orElse(null);
        }

        public Collection<FilePart> getFileParts(String field) {
            return this.getFilePartsStream(field).toList();
        }

        public Set<String> getFieldNames() {
            return this.fieldNames.get();
        }
    }
}

