/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;

public class ObjectMapperFactory {
    private static final int MAX_NESTING_DEPTH = 500;

    public static ObjectMapper createObjectMapper() {
        StreamReadConstraints constraints = StreamReadConstraints.builder().maxNestingDepth(500).build();
        JsonFactory jsonFactory = JsonFactory.builder().streamReadConstraints(constraints).build();
        return new ObjectMapper(jsonFactory).findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector(ObjectMapperFactory.createJacksonJaxbAnnotationIntrospector());
    }

    private static AnnotationIntrospector createJacksonJaxbAnnotationIntrospector() {
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        JakartaXmlBindAnnotationIntrospector jaxbIntrospector = new JakartaXmlBindAnnotationIntrospector(TypeFactory.defaultInstance());
        return AnnotationIntrospector.pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }
}

