/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.util.urlbuilder;

import com.atlassian.plugins.rest.v2.ChainingClassLoader;
import com.atlassian.plugins.rest.v2.util.urlbuilder.ProxyUtils;
import com.atlassian.plugins.rest.v2.util.urlbuilder.UnsupportedOperationInvocationHandler;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

class ByteBuddyProxyCreator {
    private final Class<?> clazz;

    ByteBuddyProxyCreator(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Object create(InvocationHandler invocationHandler) {
        try {
            Class dynamicType = new ByteBuddy().subclass(this.clazz).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)invocationHandler)).make().load((ClassLoader)new ChainingClassLoader(ProxyUtils.class.getClassLoader(), this.clazz.getClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            return ByteBuddyProxyCreator.constructDynamicTypeInstance(dynamicType);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create dynamic type proxy for %s: %s", this.clazz.getName(), e.getMessage()), e);
        }
    }

    private static Object constructDynamicTypeInstance(Class<?> dynamicType) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors = dynamicType.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException("No constructors found for class: " + dynamicType.getName());
        }
        for (Constructor<?> constructor : constructors) {
            if ((constructor.getModifiers() & 1) == 0) continue;
            int size = constructor.getParameterTypes().length;
            Object[] args = new Object[size];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ByteBuddyProxyCreator.createEmptyValue(constructor.getParameterTypes()[i]);
            }
            return constructor.newInstance(args);
        }
        throw new RuntimeException("No accessible constructor found for class: " + dynamicType.getName());
    }

    private static Object createEmptyValue(Class<?> aClass) {
        if (aClass.isInterface()) {
            return ByteBuddyProxyCreator.stubInterface(aClass);
        }
        if (aClass == Long.TYPE || aClass == Long.class) {
            return 0L;
        }
        if (aClass == Integer.TYPE || aClass == Integer.class) {
            return 0;
        }
        if (aClass == Boolean.TYPE || aClass == Boolean.class) {
            return false;
        }
        if (aClass == Character.TYPE || aClass == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (aClass == Byte.TYPE || aClass == Byte.class) {
            return (byte)0;
        }
        if (aClass == Short.TYPE || aClass == Short.class) {
            return (short)0;
        }
        if (aClass == Float.TYPE || aClass == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (aClass == Double.TYPE || aClass == Double.class) {
            return 0.0;
        }
        if (aClass == String.class) {
            return "";
        }
        if (aClass.isArray()) {
            return Array.newInstance(aClass.getComponentType(), 0);
        }
        return null;
    }

    private static Object stubInterface(Class<?> anInterface) {
        return Proxy.newProxyInstance(anInterface.getClassLoader(), new Class[]{anInterface}, (InvocationHandler)UnsupportedOperationInvocationHandler.INSTANCE);
    }
}

