/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.authentication;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugins.rest.api.security.exception.AuthenticationRequiredException;
import com.atlassian.plugins.rest.api.security.exception.AuthorizationException;
import com.atlassian.plugins.rest.v2.security.authentication.AccessType;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
@Provider
public class AuthenticatedResourceFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedResourceFilter.class);
    public static final String DEFAULT_TO_LICENSED_ACCESS_FEATURE_KEY = "atlassian.rest.default.to.licensed.access.disabled";
    public static final String DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY = "atlassian.rest.default.to.sysadmin.access.enabled";
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;
    private final ScopesRequestCache scopesRequestCache;
    @Context
    private ResourceInfo resourceInfo;

    public AuthenticatedResourceFilter(UserManager userManager, DarkFeatureManager darkFeatureManager, ScopesRequestCache scopesRequestCache) {
        this.userManager = userManager;
        this.darkFeatureManager = darkFeatureManager;
        this.scopesRequestCache = scopesRequestCache;
    }

    public void filter(ContainerRequestContext requestContext) {
        String[] scopesAllowed;
        AccessType accessType = AccessType.getAccessType(this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod());
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (AccessType.EMPTY == accessType) {
            if (this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY).orElse(false).booleanValue()) {
                if (this.userManager.isSystemAdmin(userKey)) {
                    return;
                }
            } else {
                if (this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_LICENSED_ACCESS_FEATURE_KEY).orElse(false).booleanValue()) {
                    return;
                }
                if (this.userManager.isLicensed(userKey)) {
                    return;
                }
            }
        } else if (AccessType.SYSTEM_ADMIN_ONLY == accessType ? this.userManager.isSystemAdmin(userKey) : (AccessType.ADMIN_ONLY == accessType ? this.userManager.isAdmin(userKey) || this.userManager.isSystemAdmin(userKey) : (AccessType.LICENSED_ONLY == accessType ? this.userManager.isLicensed(userKey) : (AccessType.UNLICENSED_SITE_ACCESS == accessType ? this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey) : (AccessType.ANONYMOUS_SITE_ACCESS == accessType ? userKey == null && this.userManager.isAnonymousAccessEnabled() || this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey) : AccessType.UNRESTRICTED_ACCESS == accessType))))) {
            return;
        }
        if ((scopesAllowed = this.getScopesAllowed(this.resourceInfo)) != null) {
            if (Arrays.stream(scopesAllowed).anyMatch(arg_0 -> ((ScopesRequestCache)this.scopesRequestCache).isScopePermitted(arg_0))) {
                return;
            }
        }
        log.trace("Resource class={} method={} accessType={} cannot be accessed by the current user={}", new Object[]{this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod(), accessType, userKey});
        throw AuthenticatedResourceFilter.mapToException(userKey, accessType);
    }

    public String[] getScopesAllowed(ResourceInfo resourceInfo) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        Optional<ScopesAllowed> scopesAllowedAnnotation = Stream.of(resourceMethod).filter(Objects::nonNull).map(annotatedElement -> annotatedElement.getAnnotation(ScopesAllowed.class)).filter(Objects::nonNull).findFirst();
        if (scopesAllowedAnnotation.isPresent()) {
            return scopesAllowedAnnotation.get().requiredScope();
        }
        Optional<Annotation> annotationFromDifferentClassLoader = Stream.of(resourceMethod).filter(Objects::nonNull).flatMap(annotatedElement -> Arrays.stream(annotatedElement.getAnnotations())).filter((? super T annotation) -> annotation.annotationType().getName().equals(ScopesAllowed.class.getName())).findFirst();
        if (annotationFromDifferentClassLoader.isPresent()) {
            Class resourceClass = resourceInfo.getResourceClass();
            log.error("Resource class={} method={} has ScopesAllowed annotation from a different class loader, ignoring it. Please ensure that atlassian-annotations dependency is added with a provided scope in the plugin's pom.xml", (Object)resourceClass, (Object)resourceMethod);
        }
        return new String[0];
    }

    private static SecurityException mapToException(UserKey userKey, AccessType accessType) {
        if (userKey == null) {
            return new AuthenticationRequiredException();
        }
        if (accessType == AccessType.SYSTEM_ADMIN_ONLY) {
            return new AuthorizationException("Client must be authenticated as a system administrator to access this resource.");
        }
        if (accessType == AccessType.ADMIN_ONLY) {
            return new AuthorizationException("Client must be authenticated as an administrator to access this resource.");
        }
        if (accessType == AccessType.LICENSED_ONLY) {
            throw new AuthorizationException("Client must be authenticated as a licensed user to access this resource.");
        }
        return new AuthorizationException("Client must have sufficient permissions to access this resource.");
    }
}

