/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.jersey;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class SpringInTimeResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;
    private final OsgiPlugin osgiPlugin;

    @Inject
    public SpringInTimeResolver(ServiceLocator locator, OsgiPlugin osgiPlugin) {
        this.locator = locator;
        this.osgiPlugin = osgiPlugin;
    }

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Class<?> aClass = this.getClass(failedInjectionPoint.getRequiredType());
        String name = this.getName(failedInjectionPoint);
        try {
            Object bean = name != null ? this.osgiPlugin.getContainerAccessor().getBean(name) : this.osgiPlugin.getContainerAccessor().getBean(aClass);
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)bean, (String)name, (Type[])new Type[]{failedInjectionPoint.getRequiredType()});
            return true;
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return false;
        }
    }

    private String getName(Injectee injectee) {
        return injectee.getRequiredQualifiers().stream().filter(Named.class::isInstance).map(an -> ((Named)an).value()).findFirst().orElse(null);
    }

    private Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        return null;
    }
}

