/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.jersey;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugins.rest.v2.RestApiContext;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyOsgiServletContainer
extends ServletContainer {
    private static final Logger log = LoggerFactory.getLogger(JerseyOsgiServletContainer.class);
    private static final String METRIC_NAME = "http.rest.request";
    private final OsgiPlugin plugin;
    private final RestApiContext restApiContext;

    public JerseyOsgiServletContainer(OsgiPlugin plugin, RestApiContext restApiContext, ResourceConfig resourceConfig) {
        super(resourceConfig);
        this.plugin = Objects.requireNonNull(plugin, "plugin can't be null");
        this.restApiContext = Objects.requireNonNull(restApiContext, "restApiContext can't be null");
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String baseUriPath;
        if (request.getRequestURI().contains(this.restApiContext.getPathToLatest())) {
            baseUriPath = request.getContextPath() + this.restApiContext.getPathToLatest();
            log.debug("Setting base uri for REST to 'latest'");
            log.debug("Incoming URI : {}", (Object)request.getRequestURI());
        } else {
            baseUriPath = request.getContextPath() + this.restApiContext.getPathToVersion();
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        URI baseUri = absoluteUriBuilder.replacePath(baseUriPath).path("/").build(new Object[0]);
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(request.getQueryString()).build(new Object[0]);
        try (Ticker ignored = Metrics.metric((String)METRIC_NAME).fromPluginKey(this.plugin.getKey()).tag("path", this.restApiContext.getPathToVersion()).tag("action", request.getMethod()).withAnalytics().startTimer();){
            this.service(baseUri, requestUri, request, response);
        }
    }
}

