/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.filter;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@PreMatching
public class ExtensionJerseyFilter
implements ContainerRequestFilter {
    private static final String DOT = ".";
    private final Collection<Pattern> pathExcludePatterns;
    private final Map<String, String> EXTENSION_TO_ACCEPT_HEADER = new ImmutableMap.Builder().put((Object)"txt", (Object)"text/plain").put((Object)"htm", (Object)"text/html").put((Object)"html", (Object)"text/html").put((Object)"json", (Object)"application/json").put((Object)"xml", (Object)"application/xml").put((Object)"atom", (Object)"application/atom+xml").build();

    public ExtensionJerseyFilter() {
        this.pathExcludePatterns = new LinkedList<Pattern>();
    }

    public ExtensionJerseyFilter(Collection<String> pathExcludePatterns) {
        Validate.notNull(pathExcludePatterns, (String)"The object must not be null", (Object[])new Object[0]);
        this.pathExcludePatterns = this.compilePatterns(pathExcludePatterns);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String absoluteUri = requestContext.getUriInfo().getAbsolutePath().toString();
        String extension = StringUtils.substringAfterLast((String)absoluteUri, (String)DOT);
        if (this.shouldFilter("/" + StringUtils.difference((String)requestContext.getUriInfo().getBaseUri().toString(), (String)absoluteUri), extension)) {
            requestContext.getHeaders().putSingle((Object)"Accept", (Object)this.EXTENSION_TO_ACCEPT_HEADER.get(extension));
            String absoluteUriWithoutExtension = StringUtils.substringBeforeLast((String)absoluteUri, (String)DOT);
            requestContext.setRequestUri(this.getRequestUri(absoluteUriWithoutExtension, (Map<String, List<String>>)requestContext.getUriInfo().getQueryParameters()));
        }
    }

    private boolean shouldFilter(String restPath, String extension) {
        for (Pattern pattern : this.pathExcludePatterns) {
            if (!pattern.matcher(restPath).matches()) continue;
            return false;
        }
        return this.EXTENSION_TO_ACCEPT_HEADER.containsKey(extension);
    }

    private URI getRequestUri(String absoluteUriWithoutExtension, Map<String, List<String>> queryParams) {
        UriBuilder requestUriBuilder = UriBuilder.fromUri((String)absoluteUriWithoutExtension);
        for (Map.Entry<String, List<String>> queryParamEntry : queryParams.entrySet()) {
            for (String value : queryParamEntry.getValue()) {
                requestUriBuilder.queryParam(queryParamEntry.getKey(), new Object[]{value});
            }
        }
        return requestUriBuilder.build(new Object[0]);
    }

    private Collection<Pattern> compilePatterns(Collection<String> pathExcludePatterns) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String pattern : pathExcludePatterns) {
            patterns.add(Pattern.compile(pattern));
        }
        return patterns;
    }
}

