/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.exception;

import com.atlassian.plugins.rest.api.model.Status;
import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
@Provider
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    private static final Logger log = LoggerFactory.getLogger(NotFoundExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(NotFoundException exception) {
        log.debug("Not Found Exception in REST: {}: {}", new Object[]{exception.getResponse().getStatus(), exception.getResponse(), exception});
        return Status.notFound().message(exception.getMessage()).responseBuilder().type(Status.variantFor((Request)this.request)).build();
    }
}

