/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.darkfeature;

import com.atlassian.plugins.rest.api.darkfeature.RequiresDarkFeature;
import com.atlassian.plugins.rest.v2.util.ReflectionUtils;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DarkFeatureResourceFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(DarkFeatureResourceFilter.class);
    private final DarkFeatureManager darkFeatureManager;
    private final ResourceInfo resourceInfo;

    public DarkFeatureResourceFilter(@Nonnull ResourceInfo resourceInfo, @Nonnull DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager, "darkFeatureManager can't be null");
        this.resourceInfo = Objects.requireNonNull(resourceInfo, "method can't be null");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        log.debug("Applying dark feature filter to request {} {}", (Object)requestContext.getMethod(), (Object)requestContext.getUriInfo().getRequestUri());
        if (this.accessIsAllowed(this.resourceInfo.getResourceMethod()) && this.accessIsAllowed(this.resourceInfo.getResourceClass())) {
            log.debug("Dark feature check OK");
            return;
        }
        log.debug("Dark feature check failed. Refusing access to the resource.");
        throw new NotFoundException(requestContext.getUriInfo().getRequestUri().toString());
    }

    private boolean accessIsAllowed(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return true;
        }
        RequiresDarkFeature annotation = ReflectionUtils.getAnnotation(RequiresDarkFeature.class, annotatedElement);
        return annotation == null || this.allFeaturesAreEnabled(annotation.value());
    }

    private boolean allFeaturesAreEnabled(String[] featureKeys) {
        for (String featureKey : featureKeys) {
            Optional darkFeatureEnabled = this.darkFeatureManager.isEnabledForCurrentUser(featureKey);
            if (darkFeatureEnabled.isPresent() && !Boolean.FALSE.equals(darkFeatureEnabled.get())) continue;
            return false;
        }
        return true;
    }
}

