package com.atlassian.plugins.rest.v2.exception;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.plugins.rest.v2.exception.entity.UncaughtExceptionEntity;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * Writes {@link UncaughtExceptionEntity}s out as plain text.
 */
@Priority(Priorities.USER)
@Produces(MediaType.TEXT_PLAIN)
@Provider
public class UncaughtExceptionEntityWriter implements MessageBodyWriter<UncaughtExceptionEntity> {
    private static final Logger log = LoggerFactory.getLogger(UncaughtExceptionEntityWriter.class);

    @Override
    public long getSize(
            UncaughtExceptionEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return UncaughtExceptionEntity.class.isAssignableFrom(type);
    }

    public void writeTo(
            UncaughtExceptionEntity uncaughtExceptionEntity,
            Class<?> type,
            Type genericType,
            Annotation[] annotations,
            MediaType mediaType,
            MultivaluedMap<String, Object> httpHeaders,
            OutputStream entityStream)
            throws IOException {
        log.debug(
                "Uncaught Exception in REST: {}: {}",
                uncaughtExceptionEntity.getMessage(),
                uncaughtExceptionEntity.getStackTrace());

        String plainText = uncaughtExceptionEntity.toString();
        entityStream.write(plainText.getBytes(UTF_8));
    }
}
