package com.atlassian.plugins.rest.v2.darkfeature;

import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.plugins.rest.api.darkfeature.RequiresDarkFeature;
import com.atlassian.sal.api.features.DarkFeatureManager;

import static java.util.Objects.requireNonNull;

import static com.atlassian.plugins.rest.v2.util.ReflectionUtils.getAnnotation;

@Priority(Priorities.AUTHORIZATION)
@Provider
public class DarkFeatureResourceDynamicFeature implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(DarkFeatureResourceDynamicFeature.class);

    private final DarkFeatureManager darkFeatureManager;

    public DarkFeatureResourceDynamicFeature(@Nonnull final DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = requireNonNull(darkFeatureManager);
    }

    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (getAnnotation(RequiresDarkFeature.class, resourceInfo.getResourceMethod()) != null
                || getAnnotation(RequiresDarkFeature.class, resourceInfo.getResourceClass()) != null) {
            log.debug("RequiresDarkFeature annotation found - creating filter");
            context.register(new DarkFeatureResourceFilter(resourceInfo, darkFeatureManager));
            return;
        }

        log.debug("No RequiresDarkFeature annotation found - not creating filter");
    }
}
