package com.atlassian.plugins.rest.api.security.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The intention of the annotation is to treat all uses of AnonymousAllowed as a potential Information Disclosure vulnerability,
 * and to switch to the new annotation if this usage really should ignore whether anonymous site access is allowed.
 * <p>
 * This annotation allows complete unrestricted access. It will allow unauthenticated access irrespective of whether the site
 * has enabled anonymous access or not.
 *
 * @see AnonymousSiteAccess
 * <p>
 * @since 6.3.0
 */
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.PACKAGE})
@Retention(RetentionPolicy.RUNTIME)
public @interface UnrestrictedAccess {
}