package com.atlassian.plugins.rest.api.security.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * This annotation allows anonymous resource access if the site has enabled anonymous access.
 * If anonymous access is not enabled, it will allow unlicensed user access ONLY if unlicensed access is enabled.
 * It will always allow access to licensed users.
 * @see UnrestrictedAccess
 * <p>
 * @since 6.3.0
 */
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.PACKAGE})
@Retention(RetentionPolicy.RUNTIME)
public @interface AnonymousSiteAccess {
}
