/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;

class AuthenticatedResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    private final AbstractMethod abstractMethod;
    private final AuthenticationContext authenticationContext;

    public AuthenticatedResourceFilter(AbstractMethod abstractMethod, AuthenticationContext authenticationContext) {
        this.abstractMethod = (AbstractMethod)Preconditions.checkNotNull((Object)abstractMethod);
        this.authenticationContext = (AuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
    }

    @Override
    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    @Override
    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        if (!this.isAnonymousAllowed() && !this.isClientAuthenticated()) {
            throw new AuthenticationRequiredException();
        }
        return request;
    }

    private boolean isAnonymousAllowed() {
        return this.abstractMethod.getMethod() != null && this.abstractMethod.getMethod().getAnnotation(AnonymousAllowed.class) != null || this.abstractMethod.getResource().getAnnotation(AnonymousAllowed.class) != null;
    }

    private boolean isClientAuthenticated() {
        return this.authenticationContext.isAuthenticated();
    }
}

