/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module;

import com.atlassian.plugins.rest.module.OsgiFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiServiceAccessor<S> {
    private static final String FILTER = "(|(plugin=com.atlassian.plugins.rest)(Bundle-SymbolicName=%s))";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<S> serviceType;
    private final BundleContext bundleContext;
    private ServiceReference[] references;
    private final OsgiFactory<? extends S> factory;

    OsgiServiceAccessor(Class<S> serviceType, BundleContext bundleContext, OsgiFactory<? extends S> factory) {
        this.serviceType = (Class)Preconditions.checkNotNull(serviceType);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.factory = (OsgiFactory)Preconditions.checkNotNull(factory);
    }

    Collection<? extends S> get() {
        try {
            this.references = this.bundleContext.getServiceReferences(this.serviceType.getName(), this.createFilterString(this.bundleContext.getBundle()));
            if (this.references == null) {
                return Collections.emptySet();
            }
            return ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(this.references), (Function)new Function<ServiceReference, S>(){

                public S apply(@Nullable ServiceReference serviceReference) {
                    return OsgiServiceAccessor.this.factory.getInstance(OsgiServiceAccessor.this.bundleContext, serviceReference);
                }
            }));
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Could not get service references", (Throwable)e);
            return Collections.emptyList();
        }
    }

    void release() {
        if (this.references != null) {
            for (ServiceReference reference : this.references) {
                this.bundleContext.ungetService(reference);
            }
        }
    }

    private String createFilterString(Bundle currentBundle) {
        return String.format(FILTER, currentBundle.getSymbolicName());
    }
}

