/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.doclet.generators.resourcedoc;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.plugins.rest.common.version.ApiVersion;
import com.atlassian.plugins.rest.doclet.generators.resourcedoc.JsonOperations;
import com.atlassian.plugins.rest.doclet.generators.resourcedoc.RestMethod;
import com.atlassian.plugins.rest.doclet.generators.schema.RichClass;
import com.atlassian.plugins.rest.doclet.generators.schema.SchemaGenerator;
import com.atlassian.rest.annotation.RestProperty;
import com.google.common.collect.Lists;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.generators.resourcedoc.WadlGeneratorResourceDocSupport;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.xhtml.Elements;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Response;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtlassianWadlGeneratorResourceDocSupport
extends WadlGeneratorResourceDocSupport {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private HashMap<String, ResourcePathInformation> resourcePathInformation;
    private static final Logger LOG = LoggerFactory.getLogger(AtlassianWadlGeneratorResourceDocSupport.class);
    private static final String ATLASSIAN_PLUGIN_XML = "atlassian-plugin.xml";
    private boolean generateSchemas = true;

    public AtlassianWadlGeneratorResourceDocSupport() {
    }

    public AtlassianWadlGeneratorResourceDocSupport(WadlGenerator wadlGenerator, ResourceDocType resourceDoc) {
        super(wadlGenerator, resourceDoc);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.parseAtlassianPluginXML();
    }

    public void setGenerateSchemas(Boolean generateSchemas) {
        this.generateSchemas = generateSchemas;
    }

    private void parseAtlassianPluginXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            URL resource = this.getClass().getClassLoader().getResource(ATLASSIAN_PLUGIN_XML);
            if (resource == null) {
                return;
            }
            LOG.info("Found atlassian-plugin.xml file! Looking for rest plugin module descriptors...");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.resourcePathInformation = new HashMap();
            Document document = db.parse(resource.toExternalForm());
            NodeList restPluginModuleDescriptors = document.getElementsByTagName("rest");
            int numPluginModuleDescriptors = restPluginModuleDescriptors.getLength();
            LOG.info("Found " + numPluginModuleDescriptors + " rest plugin module descriptors.");
            for (int i = 0; i < numPluginModuleDescriptors; ++i) {
                Node node = restPluginModuleDescriptors.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node pathItem = attributes.getNamedItem("path");
                Node versionItem = attributes.getNamedItem("version");
                if (pathItem == null || versionItem == null) continue;
                String resourcePath = pathItem.getNodeValue();
                String version = versionItem.getNodeValue();
                LOG.info("Found rest end point with path '" + resourcePath + "' and version '" + version + "'");
                if (resourcePath.indexOf("/") != -1) {
                    resourcePath = resourcePath.substring(resourcePath.indexOf("/") + 1);
                }
                NodeList list = node.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node child = list.item(j);
                    if (!child.getNodeName().equals("package")) continue;
                    String packageName = child.getFirstChild().getNodeValue();
                    LOG.info("Map package '" + packageName + "' to resource path '" + resourcePath + "' and version '" + version + "'");
                    this.resourcePathInformation.put(packageName, new ResourcePathInformation(resourcePath, version));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to read atlassian-plugin.xml and parse rest plugin module descriptor information. Reason", (Throwable)ex);
        }
    }

    @Override
    public Resource createResource(AbstractResource r, String path) {
        Resource result = super.createResource(r, path);
        boolean resourcePathChanged = false;
        for (String packageName : this.resourcePathInformation.keySet()) {
            if (!r.getResourceClass().getPackage().getName().startsWith(packageName)) continue;
            ResourcePathInformation pathInformation = this.resourcePathInformation.get(packageName);
            String newPath = this.buildResourcePath(result, pathInformation);
            result.setPath(newPath);
            resourcePathChanged = true;
            LOG.info("Setting resource path of rest end point '" + r.getResourceClass().getCanonicalName() + "' to '" + newPath + "'");
            break;
        }
        if (!resourcePathChanged) {
            LOG.info("Resource path of rest end point '" + r.getResourceClass().getCanonicalName() + "' unchanged no mapping to rest plugin module descriptor found.");
        }
        return result;
    }

    private String buildResourcePath(Resource result, ResourcePathInformation pathInformation) {
        if (ApiVersion.isNone(pathInformation.getVersion())) {
            return pathInformation.getPath() + "/" + result.getPath();
        }
        return pathInformation.getPath() + "/" + pathInformation.getVersion() + "/" + result.getPath();
    }

    @Override
    public Method createMethod(AbstractResource r, AbstractResourceMethod m) {
        Method method = super.createMethod(r, m);
        if (RestMethod.restMethod(r.getResourceClass(), m.getMethod()).isExperimental()) {
            method.getOtherAttributes().put(new QName("experimental"), Boolean.TRUE.toString());
        }
        if (m.getMethod().getAnnotation(Deprecated.class) != null) {
            method.getOtherAttributes().put(new QName("deprecated"), Boolean.TRUE.toString());
        }
        return method;
    }

    @Override
    public Representation createRequestRepresentation(AbstractResource r, AbstractResourceMethod m, MediaType mediaType) {
        Representation representation = super.createRequestRepresentation(r, m, mediaType);
        if (this.generateSchemas) {
            RestMethod.restMethod(r.getResourceClass(), m.getMethod()).getRequestType().ifPresent(richClass -> representation.getDoc().add(this.schemaDoc((RichClass)richClass, RestProperty.Scope.REQUEST)));
        }
        return representation;
    }

    @Override
    public List<Response> createResponses(AbstractResource r, AbstractResourceMethod m) {
        ArrayList result = Lists.newArrayList();
        for (Response response : super.createResponses(r, m)) {
            if (this.generateSchemas) {
                this.addSchemaIfDefinedForStatus(r, m, response);
            }
            result.add(response);
        }
        return result;
    }

    private void addSchemaIfDefinedForStatus(AbstractResource resource, AbstractResourceMethod method, Response response) {
        for (Long status : response.getStatus()) {
            for (RichClass responseType : RestMethod.restMethod(resource.getResourceClass(), method.getMethod()).responseTypesFor(status.intValue())) {
                for (Representation representation : response.getRepresentation()) {
                    representation.getDoc().add(this.schemaDoc(responseType, RestProperty.Scope.RESPONSE));
                }
            }
        }
    }

    private Doc schemaDoc(RichClass model, RestProperty.Scope scope) {
        String schema = JsonOperations.toJson(SchemaGenerator.generateSchema(model, scope));
        Doc doc = new Doc();
        Elements element = Elements.el("p").add(Elements.val("h6", "Schema")).add(new Object[]{Elements.el("pre").add(Elements.val("code", schema))});
        doc.getContent().add((Object)element);
        return doc;
    }

    public class ResourcePathInformation {
        private final String path;
        private final String version;

        public ResourcePathInformation(String path, String version) {
            this.path = path;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPath() {
            return this.path;
        }
    }
}

