/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.xml;

import com.sun.jersey.core.impl.provider.xml.ThreadLocalSingletonContextProvider;
import com.sun.jersey.core.util.FeaturesAndProperties;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class TransformerFactoryProvider
extends ThreadLocalSingletonContextProvider<TransformerFactory> {
    private static final Logger LOGGER = Logger.getLogger(TransformerFactoryProvider.class.getName());
    private final boolean disableXmlSecurity;

    public TransformerFactoryProvider(@Context FeaturesAndProperties fps) {
        super(TransformerFactory.class);
        this.disableXmlSecurity = fps.getFeature("com.sun.jersey.config.feature.DisableXmlSecurity");
    }

    @Override
    protected TransformerFactory getInstance() {
        TransformerFactory f = TransformerFactory.newInstance();
        if (!this.disableXmlSecurity) {
            try {
                f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Security features for the TransformerFactory could not be enabled", e);
            }
        }
        return f;
    }
}

