/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.xml;

import com.sun.jersey.core.impl.provider.xml.ThreadLocalSingletonContextProvider;
import com.sun.jersey.core.util.FeaturesAndProperties;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderFactoryProvider
extends ThreadLocalSingletonContextProvider<DocumentBuilderFactory> {
    private static final Logger LOGGER = Logger.getLogger(DocumentBuilderFactoryProvider.class.getName());
    private final boolean disableXmlSecurity;

    public DocumentBuilderFactoryProvider(@Context FeaturesAndProperties fps) {
        super(DocumentBuilderFactory.class);
        this.disableXmlSecurity = fps.getFeature("com.sun.jersey.config.feature.DisableXmlSecurity");
    }

    @Override
    protected DocumentBuilderFactory getInstance() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        if (!this.disableXmlSecurity) {
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            try {
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Security features for the DocumentBuilderFactory could not be enabled", e);
            }
        }
        return documentBuilderFactory;
    }
}

