/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.jersey;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugins.rest.module.ChainingClassLoader;
import com.atlassian.plugins.rest.module.jersey.EntityConversionException;
import com.atlassian.plugins.rest.module.jersey.HeaderHelper;
import com.atlassian.plugins.rest.module.jersey.JerseyEntityHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyResponse
implements Response {
    private final Response delegateResponse;
    private final JerseyEntityHandler jerseyEntityHandler;
    private final Plugin plugin;

    public JerseyResponse(Response delegateResponse, JerseyEntityHandler jerseyEntityHandler, Plugin plugin) {
        this.delegateResponse = delegateResponse;
        this.jerseyEntityHandler = jerseyEntityHandler;
        this.plugin = plugin;
    }

    public <T> T getEntity(Class<T> entityClass) throws ResponseException {
        Map<String, String> headers = this.getHeaders();
        HashMap<String, List<String>> headerListMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headerListMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        String contentType = HeaderHelper.getSingleHeaderValue(headerListMap, "Content-Type", "application/xml");
        InputStream entityStream = this.getResponseBodyAsStream();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ChainingClassLoader chainingClassLoader = this.getChainingClassLoader(this.plugin);
        try {
            Thread.currentThread().setContextClassLoader(chainingClassLoader);
            T t = this.jerseyEntityHandler.unmarshall(entityClass, MediaType.valueOf(contentType), entityStream, headerListMap);
            return t;
        }
        catch (IOException e) {
            throw new EntityConversionException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public int getStatusCode() {
        return this.delegateResponse.getStatusCode();
    }

    public String getResponseBodyAsString() throws ResponseException {
        return this.delegateResponse.getResponseBodyAsString();
    }

    public InputStream getResponseBodyAsStream() throws ResponseException {
        return this.delegateResponse.getResponseBodyAsStream();
    }

    public String getStatusText() {
        return this.delegateResponse.getStatusText();
    }

    public boolean isSuccessful() {
        return this.delegateResponse.isSuccessful();
    }

    public String getHeader(String s) {
        return this.delegateResponse.getHeader(s);
    }

    public Map<String, String> getHeaders() {
        return this.delegateResponse.getHeaders();
    }

    private ChainingClassLoader getChainingClassLoader(Plugin plugin) {
        return new ChainingClassLoader(this.getClass().getClassLoader(), plugin.getClassLoader());
    }
}

