/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.plugins.rest.common.security.jersey.AuthenticatedResourceFilter;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class AuthenticatedResourceFilterFactory
implements ResourceFilterFactory {
    private final AuthenticationContext authenticationContext;

    public AuthenticatedResourceFilterFactory(AuthenticationContext authenticationContext) {
        this.authenticationContext = (AuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
    }

    @Override
    public List<ResourceFilter> create(AbstractMethod abstractMethod) {
        return Collections.singletonList(new AuthenticatedResourceFilter(abstractMethod, this.authenticationContext));
    }
}

