/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.json;

import com.atlassian.plugins.rest.common.json.JacksonJsonProviderFactory;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBException;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.SerializationConfig;

public class DefaultJaxbJsonMarshaller
implements JaxbJsonMarshaller {
    private final boolean prettyPrint;

    public DefaultJaxbJsonMarshaller() {
        this(false);
    }

    public DefaultJaxbJsonMarshaller(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String marshal(Object jaxbBean) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JacksonJsonProvider jsonProvider = new JacksonJsonProviderFactory().create(Collections.emptyList());
            if (this.prettyPrint) {
                jsonProvider.enable(SerializationConfig.Feature.INDENT_OUTPUT, true);
            }
            jsonProvider.writeTo(jaxbBean, jaxbBean.getClass(), (Type)null, (Annotation[])null, MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap<String, Object>)null, (OutputStream)os);
            return new String(os.toByteArray(), JsonEncoding.UTF8.getJavaName());
        }
        catch (IOException e) {
            throw new JsonMarshallingException(e);
        }
    }

    @Deprecated
    public String marshal(Object jaxbBean, Class ... jaxbClasses) throws JAXBException {
        return this.marshal(jaxbBean);
    }
}

