/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.atlassian.plugins.rest.common.security.AuthorisationException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import javax.ws.rs.ext.Provider;

@Provider
public class AdminOnlyResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    private final UserManager userManager;

    public AdminOnlyResourceFilter(UserManager userManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    public ContainerRequest filter(ContainerRequest containerRequest) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            throw new AuthenticationRequiredException();
        }
        if (!this.userManager.isAdmin(userKey)) {
            throw new AuthorisationException("Client must be authenticated as an administrator to access this resource.");
        }
        return containerRequest;
    }
}

