package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.sun.jersey.spi.container.ContainerRequest;

/**
 * Protects browsers against XSRF attacks where the origin of a request would not
 * otherwise be permitted by the same origin policy or CORS.
 *
 * @since 2.9.21
 */
class OriginBasedXsrfResourceFilter extends XsrfResourceFilter {

    public ContainerRequest filter(final ContainerRequest request) {
        if (!isPostRequest(request) || !isLikelyToBeFromBrowser(request) ||
                (request.getMediaType() != null && isXsrfable(request))) {
            return request;
        }
        if (passesAdditionalBrowserChecks(request)) {
            return request;
        }
        throw new XsrfCheckFailedException();
    }

}
