/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.multipart.fileupload;

import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.FileSizeLimitExceededException;
import com.atlassian.plugins.rest.common.multipart.MultipartForm;
import com.atlassian.plugins.rest.common.multipart.MultipartHandler;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class CommonsFileUploadMultipartHandler
implements MultipartHandler {
    private final ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());

    public CommonsFileUploadMultipartHandler(long maxFileSize, long maxSize) {
        this.servletFileUpload.setFileSizeMax(maxFileSize);
        this.servletFileUpload.setSizeMax(maxSize);
    }

    public FilePart getFilePart(HttpServletRequest request, String field) {
        return this.getForm(request).getFilePart(field);
    }

    public MultipartForm getForm(HttpServletRequest request) {
        return this.getForm((RequestContext)new ServletRequestContext(request));
    }

    public MultipartForm getForm(RequestContext request) {
        try {
            return new CommonsFileUploadMultipartForm(this.servletFileUpload.parseRequest(request));
        }
        catch (FileUploadException e) {
            if (e instanceof FileUploadBase.FileSizeLimitExceededException || e instanceof FileUploadBase.SizeLimitExceededException) {
                throw new FileSizeLimitExceededException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    private static class CommonsFileUploadFilePart
    implements FilePart {
        private final FileItem fileItem;

        CommonsFileUploadFilePart(FileItem fileItem) {
            this.fileItem = (FileItem)Preconditions.checkNotNull((Object)fileItem);
        }

        public String getName() {
            return this.fileItem.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public void write(File file) throws IOException {
            try {
                this.fileItem.write(file);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        public String getValue() {
            return this.fileItem.getString();
        }

        public boolean isFormField() {
            return this.fileItem.isFormField();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonsFileUploadMultipartForm
    implements MultipartForm {
        private final Collection<FileItem> fileItems;

        private CommonsFileUploadMultipartForm(Collection<FileItem> fileItems) {
            this.fileItems = fileItems;
        }

        @Override
        public FilePart getFilePart(String field) {
            for (FileItem item : this.fileItems) {
                if (!item.getFieldName().equals(field)) continue;
                return new CommonsFileUploadFilePart(item);
            }
            return null;
        }

        @Override
        public Collection<FilePart> getFileParts(String field) {
            ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
            for (FileItem item : this.fileItems) {
                if (!item.getFieldName().equals(field)) continue;
                fileParts.add(new CommonsFileUploadFilePart(item));
            }
            return fileParts;
        }
    }
}

