/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.interceptor.impl;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.atlassian.plugins.rest.common.interceptor.impl.DefaultMethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.impl.InterceptorChainBuilder;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.server.impl.ResponseBuilderImpl;
import com.sun.jersey.server.impl.inject.InjectableValuesProvider;
import com.sun.jersey.server.impl.model.method.dispatch.ResourceJavaMethodDispatcher;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DispatchProviderHelper {
    private final InterceptorChainBuilder interceptorChainBuilder;

    public DispatchProviderHelper(InterceptorChainBuilder interceptorChainBuilder) {
        this.interceptorChainBuilder = interceptorChainBuilder;
    }

    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp) {
        if (pp == null) {
            return null;
        }
        List<ResourceInterceptor> interceptors = this.interceptorChainBuilder.getResourceInterceptorsForMethod(abstractResourceMethod.getMethod());
        boolean requireReturnOfRepresentation = "GET".equals(abstractResourceMethod.getHttpMethod());
        Class<?> returnType = abstractResourceMethod.getMethod().getReturnType();
        if (Response.class.isAssignableFrom(returnType)) {
            return new ResponseOutInvoker(abstractResourceMethod, pp, interceptors);
        }
        if (returnType != Void.TYPE) {
            if (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType)) {
                return new ObjectOutInvoker(abstractResourceMethod, pp, interceptors);
            }
            return new TypeOutInvoker(abstractResourceMethod, pp, interceptors);
        }
        if (requireReturnOfRepresentation) {
            return null;
        }
        return new VoidOutInvoker(abstractResourceMethod, pp, interceptors);
    }

    private static void invokeMethodWithInterceptors(List<ResourceInterceptor> originalInterceptors, AbstractResourceMethod method, Object resource, HttpContext httpContext, Object[] params, final MethodInvoker methodInvocation) throws IllegalAccessException, InvocationTargetException {
        ResourceInterceptor lastInterceptor = new ResourceInterceptor(){

            public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
                methodInvocation.invoke();
            }
        };
        ArrayList<ResourceInterceptor> interceptors = new ArrayList<ResourceInterceptor>(originalInterceptors);
        interceptors.add(lastInterceptor);
        DefaultMethodInvocation inv = new DefaultMethodInvocation(resource, method, httpContext, interceptors, params);
        inv.invoke();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectOutInvoker
    extends EntityParamInInvoker {
        ObjectOutInvoker(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp, List<ResourceInterceptor> interceptors) {
            super(abstractResourceMethod, pp, interceptors);
        }

        public void _dispatch(final Object resource, final HttpContext context) throws IllegalAccessException, InvocationTargetException {
            final Object[] params = this.getParams(context);
            DispatchProviderHelper.invokeMethodWithInterceptors(this.interceptors, this.abstractResourceMethod, resource, context, params, new MethodInvoker(){

                public void invoke() throws IllegalAccessException, InvocationTargetException {
                    Object o = ObjectOutInvoker.this.method.invoke(resource, params);
                    if (o instanceof Response) {
                        Response r = (Response)o;
                        context.getResponse().setResponse(r);
                    } else if (o != null) {
                        Response r = new ResponseBuilderImpl().status(200).entity(o).build();
                        context.getResponse().setResponse(r);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResponseOutInvoker
    extends EntityParamInInvoker {
        ResponseOutInvoker(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp, List<ResourceInterceptor> interceptors) {
            super(abstractResourceMethod, pp, interceptors);
        }

        public void _dispatch(final Object resource, final HttpContext context) throws IllegalAccessException, InvocationTargetException {
            final Object[] params = this.getParams(context);
            DispatchProviderHelper.invokeMethodWithInterceptors(this.interceptors, this.abstractResourceMethod, resource, context, params, new MethodInvoker(){

                public void invoke() throws IllegalAccessException, InvocationTargetException {
                    Response r = (Response)ResponseOutInvoker.this.method.invoke(resource, params);
                    if (r != null) {
                        context.getResponse().setResponse(r);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeOutInvoker
    extends EntityParamInInvoker {
        private final Type t;

        TypeOutInvoker(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp, List<ResourceInterceptor> interceptors) {
            super(abstractResourceMethod, pp, interceptors);
            this.t = abstractResourceMethod.getMethod().getGenericReturnType();
        }

        public void _dispatch(final Object resource, final HttpContext context) throws IllegalAccessException, InvocationTargetException {
            final Object[] params = this.getParams(context);
            DispatchProviderHelper.invokeMethodWithInterceptors(this.interceptors, this.abstractResourceMethod, resource, context, params, new MethodInvoker(){

                public void invoke() throws IllegalAccessException, InvocationTargetException {
                    Object o = TypeOutInvoker.this.method.invoke(resource, params);
                    if (o != null) {
                        Response r = new ResponseBuilderImpl().entityWithType(o, TypeOutInvoker.this.t).status(200).build();
                        context.getResponse().setResponse(r);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VoidOutInvoker
    extends EntityParamInInvoker {
        VoidOutInvoker(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp, List<ResourceInterceptor> interceptors) {
            super(abstractResourceMethod, pp, interceptors);
        }

        public void _dispatch(final Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            final Object[] params = this.getParams(context);
            DispatchProviderHelper.invokeMethodWithInterceptors(this.interceptors, this.abstractResourceMethod, resource, context, params, new MethodInvoker(){

                public void invoke() throws IllegalAccessException, InvocationTargetException {
                    VoidOutInvoker.this.method.invoke(resource, params);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class EntityParamInInvoker
    extends ResourceJavaMethodDispatcher {
        private final InjectableValuesProvider pp;
        final AbstractResourceMethod abstractResourceMethod;
        final List<ResourceInterceptor> interceptors;

        EntityParamInInvoker(AbstractResourceMethod abstractResourceMethod, InjectableValuesProvider pp, List<ResourceInterceptor> interceptors) {
            super(abstractResourceMethod);
            this.pp = pp;
            this.abstractResourceMethod = abstractResourceMethod;
            this.interceptors = interceptors;
        }

        final Object[] getParams(HttpContext context) {
            return this.pp.getInjectableValues(context);
        }
    }

    private static interface MethodInvoker {
        public void invoke() throws IllegalAccessException, InvocationTargetException;
    }
}

