/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandContext;
import com.atlassian.plugins.rest.common.expand.resolver.AbstractEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEntityExpanderResolver
extends AbstractEntityExpanderResolver {
    private static final List<Class<? extends Collection>> TYPES = Lists.newArrayList((Object[])new Class[]{List.class, Collection.class});
    private static final Map<Class<?>, EntityExpander<?>> EXPANDERS = ImmutableMap.builder().put(List.class, (Object)new ListExpander()).put(Collection.class, (Object)new CollectionExpander()).build();

    @Override
    public boolean hasExpander(Class<?> type) {
        for (Class<? extends Collection> expandableType : TYPES) {
            if (!expandableType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        for (Class<? extends Collection> expandableType : TYPES) {
            if (!expandableType.isAssignableFrom(type)) continue;
            return EXPANDERS.get(expandableType);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionExpander
    implements EntityExpander<Collection> {
        private CollectionExpander() {
        }

        @Override
        public Collection expand(ExpandContext<Collection> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            LinkedList list = new LinkedList();
            for (Object item : context.getEntity()) {
                DefaultExpandContext itemContext = new DefaultExpandContext(item, context.getExpandable(), context.getEntityExpandParameter());
                EntityExpander entityExpander = expanderResolver.getExpander(item);
                list.add(entityExpander != null ? entityExpander.expand(itemContext, expanderResolver, entityCrawler) : item);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListExpander
    implements EntityExpander<List> {
        private ListExpander() {
        }

        @Override
        public List expand(ExpandContext<List> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            LinkedList list = new LinkedList();
            for (Object item : context.getEntity()) {
                DefaultExpandContext itemContext = new DefaultExpandContext(item, context.getExpandable(), context.getEntityExpandParameter());
                EntityExpander entityExpander = expanderResolver.getExpander(item);
                list.add(entityExpander != null ? entityExpander.expand(itemContext, expanderResolver, entityCrawler) : item);
            }
            return list;
        }
    }
}

