/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandContext;
import com.atlassian.plugins.rest.common.expand.ExpandException;
import com.atlassian.plugins.rest.common.expand.resolver.AbstractEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEntityExpanderResolver
extends AbstractEntityExpanderResolver {
    private static Map<Class<?>, EntityExpander<?>> EXPANDERS = new HashMap<Class<?>, EntityExpander<?>>(){
        {
            this.put(Collection.class, new CollectionExpander());
            this.put(List.class, new ListExpander());
        }
    };

    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        EntityExpander<?> entityExpander = EXPANDERS.get(type);
        if (entityExpander != null) {
            return entityExpander;
        }
        throw new ExpandException("Could not find expander in Iterable expander resolver");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionExpander
    implements EntityExpander<Collection> {
        private CollectionExpander() {
        }

        @Override
        public Collection expand(ExpandContext<Collection> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            LinkedList list = new LinkedList();
            for (Object item : context.getEntity()) {
                DefaultExpandContext itemContext = new DefaultExpandContext(item, context.getExpandable(), context.getEntityExpandParameter());
                list.add(expanderResolver.getExpander(item).expand(itemContext, expanderResolver, entityCrawler));
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListExpander
    implements EntityExpander<List> {
        private ListExpander() {
        }

        @Override
        public List expand(ExpandContext<List> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            LinkedList list = new LinkedList();
            for (Object item : context.getEntity()) {
                DefaultExpandContext itemContext = new DefaultExpandContext(item, context.getExpandable(), context.getEntityExpandParameter());
                list.add(expanderResolver.getExpander(item).expand(itemContext, expanderResolver, entityCrawler));
            }
            return list;
        }
    }
}

