/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandException;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.base.Preconditions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingEntityExpanderResolver
implements EntityExpanderResolver {
    private final List<EntityExpanderResolver> resolvers;

    public ChainingEntityExpanderResolver(List<EntityExpanderResolver> resolvers) {
        this.resolvers = (List)Preconditions.checkNotNull(resolvers);
    }

    @Override
    public <T> EntityExpander<T> getExpander(T instance) {
        return this.getExpander(instance.getClass());
    }

    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        for (EntityExpanderResolver resolver : this.resolvers) {
            try {
                return resolver.getExpander(type);
            }
            catch (ExpandException e) {
            }
        }
        throw new ExpandException("Could not find expander for " + type);
    }
}

