package com.atlassian.plugins.rest.common.json;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;

import javax.xml.bind.JAXBException;

/**
 * Creates a JSONJAXBContext using the {@link com.sun.jersey.api.json.JSONConfiguration#natural()} configuration.
 *
 * @since v1.0.2
 */
public class DefaultJsonJaxbContextFactory implements JsonJaxbContextFactory
{
    public JSONJAXBContext createContext(final Class... classes)
    {
        try
        {
            return new JSONJAXBContext(JSONConfiguration.natural().build(), classes);
        }
        catch (JAXBException e)
        {
            throw new RuntimeException("Could not create JAXB JSON context", e);
        }
    }
}
