package com.atlassian.plugins.rest.common.json;

import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.json.impl.JSONMarshaller;

import java.io.StringWriter;
import javax.xml.bind.JAXBException;

public class DefaultJaxbJsonMarshaller implements JaxbJsonMarshaller
{
    public String marshal(final Object jaxbBean, final Class... jaxbClasses) throws JAXBException
    {
        final JsonJaxbContextFactory contextFaxtory = new DefaultJsonJaxbContextFactory();
        final JSONJAXBContext jsonjaxbContext = contextFaxtory.createContext(jaxbClasses);
        final StringWriter out = new StringWriter();
        final JSONMarshaller marshaller = (JSONMarshaller) jsonjaxbContext.createMarshaller();
        marshaller.setJsonEnabled(true);
        marshaller.marshal(jaxbBean, out);
        return out.toString();
    }
}
