package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.AbstractRecursiveEntityExpander;

public class IdentityEntityExpanderResolver extends AbstractEntityExpanderResolver
{
    private final static EntityExpander IDENTITY = new IdentityExpander();

    public <T> EntityExpander<T> getExpander(Class<? extends T> type)
    {
        return IDENTITY;
    }

    private static class IdentityExpander extends AbstractRecursiveEntityExpander<Object>
    {
        protected Object expandInternal(Object entity)
        {
            return entity;
        }
    }
}
