package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandException;

/**
 * <p>A resolver to find the expander for object or classes.</p>
 * <p>It is recommended for implementations to 
 */
public interface EntityExpanderResolver
{
    /**
     * Gets an {@link EntityExpander} for the given instance.
     * @param instance the object to look up the expander for.
     * @param <T> the type of object to retrieve the expander for.
     * @return the EntityExpander
     * @throws ExpandException if no {@link EntityExpander} could be found for the instance.
     */
    <T> EntityExpander<T> getExpander(T instance);

    /**
     * Gets an {@link EntityExpander} for the given type.
     * @param type the type of object to look up the expander for.
     * @param <T> the type of object to retrieve the expander for.
     * @return the EntityExpander
     * @throws ExpandException if no {@link EntityExpander} could be found for the instance.
     */
    <T> EntityExpander<T> getExpander(Class<? extends T> type);
}
