package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandContext;
import com.atlassian.plugins.rest.common.expand.ExpandException;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CollectionEntityExpanderResolver extends AbstractEntityExpanderResolver
{
    private static Map<Class<?>, EntityExpander<?>> EXPANDERS = new HashMap<Class<?>, EntityExpander<?>>()
    {{
            put(Collection.class, new CollectionExpander());
            put(List.class, new ListExpander());
        }};


    @SuppressWarnings("unchecked")
    public <T> EntityExpander<T> getExpander(Class<? extends T> type)
    {
        final EntityExpander<?> entityExpander = EXPANDERS.get(type);
        if (entityExpander != null)
        {
            return (EntityExpander<T>) entityExpander;
        }
        throw new ExpandException("Could not find expander in Iterable expander resolver");
    }

    private static class ListExpander implements EntityExpander<List>
    {
        public List expand(ExpandContext<List> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler)
        {
            final List list = new LinkedList();
            for (Object item : context.getEntity())
            {
                final ExpandContext<Object> itemContext = new DefaultExpandContext<Object>(item, context.getExpandable(), context.getEntityExpandParameter());
                list.add(expanderResolver.getExpander(item).expand(itemContext, expanderResolver, entityCrawler));
            }
            return list;
        }
    }

    private static class CollectionExpander implements EntityExpander<Collection>
    {
        public Collection expand(ExpandContext<Collection> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler)
        {
            final List list = new LinkedList();
            for (Object item : context.getEntity())
            {
                final ExpandContext<Object> itemContext = new DefaultExpandContext<Object>(item, context.getExpandable(), context.getEntityExpandParameter());
                list.add(expanderResolver.getExpander(item).expand(itemContext, expanderResolver, entityCrawler));
            }
            return list;
        }
    }
}
