package com.atlassian.plugins.rest.common.expand.resolver;

import com.google.common.base.Preconditions;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandException;

import java.util.List;

public class ChainingEntityExpanderResolver implements EntityExpanderResolver
{
    private final List<EntityExpanderResolver> resolvers;

    public ChainingEntityExpanderResolver(List<EntityExpanderResolver> resolvers)
    {
        this.resolvers = Preconditions.checkNotNull(resolvers);
    }

    @SuppressWarnings("unchecked")
    public <T> EntityExpander<T> getExpander(T instance)
    {
        return (EntityExpander<T>) getExpander(instance.getClass());
    }

    public <T> EntityExpander<T> getExpander(Class<? extends T> type)
    {
        for (EntityExpanderResolver resolver : resolvers)
        {
            try
            {
                return resolver.getExpander(type);
            }
            catch (ExpandException e)
            {
                // ignore
            }
        }
        throw new ExpandException("Could not find expander for " + type);
    }
}
