package com.atlassian.plugins.rest.common.expand.jersey;

import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.base.Preconditions;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;

import javax.ws.rs.ext.Provider;

/**
 * <p>The response filter that handled entity expansion.</p>
 * <p>By default it looks up the {@code expand} query parameter. If the parameter exists (and contains relevant information) the filter
 * triggers the expansion of the current entity in the {@link ContainerResponse response}.</p>
 */
@Provider
public class ExpandResponseFilter implements ContainerResponseFilter
{
    private final String expandParameterName;
    private final EntityExpanderResolver expanderResolver;

    public ExpandResponseFilter(EntityExpanderResolver expanderResolver)
    {
        this("expand", expanderResolver);
    }

    public ExpandResponseFilter(String expandParameterName, EntityExpanderResolver expanderResolver)
    {
        this.expanderResolver = expanderResolver;
        this.expandParameterName = Preconditions.checkNotNull(expandParameterName);
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response)
    {
        final ExpandParameter expandParameter = new DefaultExpandParameter(request.getQueryParameters().get(expandParameterName));
        new EntityCrawler().crawl(response.getEntity(), expandParameter, expanderResolver);
        return response;
    }
}
