/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.impl;

import com.atlassian.linkaggregation.RemoteLinkAggregateTimeModifiedService;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregator;
import com.atlassian.linkaggregation.impl.Iterables2;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregationModel;
import com.atlassian.linkaggregation.impl.RemoteLinkAggregatorModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class RemoteLinkAggregatorService {
    private static final Function<RemoteLinkAggregatorModuleDescriptor, RemoteLinkAggregator> TO_MODULE = RemoteLinkAggregatorService.getModule();
    private static final int CHUNK_SIZE = 100;
    private final PluginAccessor pluginAccessor;
    private final LoadingCache<String, DateTime> dateModifiedCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, DateTime>(){

        public DateTime load(String key) throws Exception {
            return DateTime.now();
        }
    });

    public RemoteLinkAggregatorService(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public DateTime getLastModified(final List<String> globalIds) {
        List enabledTimeModifiedServices = this.pluginAccessor.getEnabledModulesByClass(RemoteLinkAggregateTimeModifiedService.class);
        if (enabledTimeModifiedServices.isEmpty()) {
            return DateTime.now();
        }
        return (DateTime)Ordering.natural().max(Iterables.transform((Iterable)Iterables.filter((Iterable)enabledTimeModifiedServices, (Predicate)Predicates.notNull()), (Function)new Function<RemoteLinkAggregateTimeModifiedService, DateTime>(){

            public DateTime apply(@Nullable RemoteLinkAggregateTimeModifiedService timeModifiedService) {
                return timeModifiedService.getLastModified(globalIds);
            }
        }));
    }

    public Iterable<RemoteLinkAggregationModel> aggregateLinksByGlobalId(List<String> globalIds) {
        List enabledMD = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RemoteLinkAggregatorModuleDescriptor.class);
        return this.aggregateLinksByGlobalIdChunked(globalIds, (List<RemoteLinkAggregator>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)enabledMD, (Predicate)Predicates.notNull()), TO_MODULE), (Predicate)Predicates.notNull())), 100);
    }

    @VisibleForTesting
    Iterable<RemoteLinkAggregationModel> aggregateLinksByGlobalIdChunked(Iterable<String> globalIds, final List<RemoteLinkAggregator> aggregators, int chunkSize) {
        return Iterables2.chunk(Iterables.filter(globalIds, (Predicate)Predicates.notNull()), new Function<Iterable<String>, Iterable<RemoteLinkAggregationModel>>(){

            public Iterable<RemoteLinkAggregationModel> apply(Iterable<String> input) {
                Map aggregations = RemoteLinkAggregatorService.this.aggregateLinksByGlobalId(input, aggregators);
                return Iterables.transform(aggregations.entrySet(), (Function)new Function<Map.Entry<String, Iterable<RemoteLinkAggregation>>, RemoteLinkAggregationModel>(){

                    public RemoteLinkAggregationModel apply(Map.Entry<String, Iterable<RemoteLinkAggregation>> input) {
                        return new RemoteLinkAggregationModel(input.getKey(), input.getValue());
                    }
                });
            }
        }, chunkSize);
    }

    private Map<String, Iterable<RemoteLinkAggregation>> aggregateLinksByGlobalId(Iterable<String> globalIds, List<RemoteLinkAggregator> aggregators) {
        ImmutableList empty = ImmutableList.of();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (RemoteLinkAggregator aggregator : aggregators) {
            Map results = aggregator.aggregateForGlobalIds(globalIds);
            for (String key : results.keySet()) {
                map.put(key, Iterables.concat((Iterable)((Iterable)Objects.firstNonNull(map.get(key), (Object)empty)), (Iterable)((Iterable)Objects.firstNonNull(results.get(key), (Object)empty))));
            }
        }
        return map;
    }

    private static <T extends AbstractModuleDescriptor<R>, R> Function<T, R> getModule() {
        return new Function<T, R>(){

            public R apply(T descriptor) {
                return descriptor.getModule();
            }
        };
    }
}

