/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.spi.module;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.remotable.spi.module.IFrameRenderer;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IFrameViewIssuePanel
implements WebPanel {
    private static final Logger log = LoggerFactory.getLogger(IFrameViewIssuePanel.class);
    private final IFrameRenderer iFrameRenderer;
    private final IFrameContext iFrameContext;
    private final boolean hiddenByDefault;

    public IFrameViewIssuePanel(IFrameRenderer iFrameRenderer, IFrameContext iFrameContext, boolean hiddenByDefault) {
        this.iFrameRenderer = iFrameRenderer;
        this.iFrameContext = iFrameContext;
        this.hiddenByDefault = hiddenByDefault;
    }

    public String getHtml(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            this.writeHtml(writer, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        try {
            User user = (User)context.get("user");
            String remoteUser = user != null ? user.getName() : null;
            HashMap params = Maps.newHashMap();
            params.put("issue_id", new String[]{context.containsKey("issue") ? String.valueOf(((Issue)context.get("issue")).getId()) : ""});
            params.put("project_id", new String[]{context.containsKey("project") ? String.valueOf(((Project)context.get("project")).getId()) : ""});
            String iframe = this.iFrameRenderer.render(this.iFrameContext, "", params, remoteUser);
            if (this.hiddenByDefault) {
                iframe = "<script>AJS.$('#" + this.iFrameContext.getNamespace() + "').addClass('hidden');</script>" + iframe;
            }
            writer.write(iframe);
        }
        catch (PermissionDeniedException ex) {
            writer.write("Unauthorized to view this panel");
            log.warn("Unauthorized view of panel");
        }
        catch (IOException e) {
            writer.write("Unable to render panel: " + e.getMessage());
            log.error("Error rendering panel", (Throwable)e);
        }
    }
}

