/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.DefaultBigPipeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingConcurrentMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

final class LoggingConcurrentMap
extends ForwardingConcurrentMap<String, DefaultBigPipeManager.BigPipeImpl> {
    private final Logger logger;
    private final ConcurrentMap<String, DefaultBigPipeManager.BigPipeImpl> delegate;

    LoggingConcurrentMap(Logger logger, ConcurrentMap<String, DefaultBigPipeManager.BigPipeImpl> delegate) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        this.delegate = (ConcurrentMap)Preconditions.checkNotNull(delegate);
    }

    protected ConcurrentMap<String, DefaultBigPipeManager.BigPipeImpl> delegate() {
        return this.delegate;
    }

    public DefaultBigPipeManager.BigPipeImpl get(Object key) {
        DefaultBigPipeManager.BigPipeImpl bigPipe = (DefaultBigPipeManager.BigPipeImpl)super.get(key);
        this.logger.debug("Getting big pipe for request '{}'. It's value is {}", key, (Object)bigPipe);
        return bigPipe;
    }

    public DefaultBigPipeManager.BigPipeImpl remove(Object key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removing big pipe for request '{}', which is {}in the map.", key, (Object)(this.containsKey(key) ? "" : "NOT"));
        }
        return (DefaultBigPipeManager.BigPipeImpl)super.remove(key);
    }

    public DefaultBigPipeManager.BigPipeImpl putIfAbsent(String key, DefaultBigPipeManager.BigPipeImpl value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding big pipe for request '{}' if not already there. It's value is {}", (Object)key, (Object)value);
        }
        return (DefaultBigPipeManager.BigPipeImpl)super.putIfAbsent((Object)key, (Object)value);
    }
}

