/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http;

import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.plugin.remotable.api.service.http.HostHttpClient;
import com.atlassian.plugin.remotable.api.service.http.HostXmlRpcClient;
import com.atlassian.plugin.remotable.api.service.http.XmlRpcException;
import com.atlassian.plugin.remotable.api.service.http.XmlRpcFault;
import com.atlassian.plugin.remotable.host.common.service.http.FaultHandlingXmlRpcParser;
import com.atlassian.plugin.remotable.host.common.service.http.PromiseAwareXmlRpcInvocationHandler;
import com.atlassian.plugin.util.ChainingClassLoader;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.xmlrpc.BindingException;
import com.atlassian.xmlrpc.ServiceObject;
import com.atlassian.xmlrpc.XmlRpcClientProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Vector;
import java.util.concurrent.Callable;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcSerializer;
import redstone.xmlrpc.XmlRpcStruct;

public class DefaultHostXmlRpcClient
implements HostXmlRpcClient {
    private static final URI serverXmlRpcPath = URI.create("/rpc/xmlrpc");
    private final XmlRpcSerializer serializer = new XmlRpcSerializer();
    private final HostHttpClient httpClient;

    public DefaultHostXmlRpcClient(HostHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public <T> T bind(Class<T> bindClass) {
        if (!bindClass.isInterface()) {
            throw new IllegalArgumentException("Class " + bindClass.getName() + "is not an interface");
        }
        ServiceObject serviceObject = bindClass.getAnnotation(ServiceObject.class);
        if (serviceObject == null) {
            throw new IllegalArgumentException("Could not find ServiceObject annotation on " + bindClass.getName());
        }
        PromiseAwareXmlRpcInvocationHandler handler = new PromiseAwareXmlRpcInvocationHandler(new XmlRpcClientProvider(){

            @Override
            public Object execute(String serviceName, String methodName, Vector arguments) throws BindingException {
                Object[] argsWithToken = new Object[arguments.size() + 1];
                argsWithToken[0] = "";
                System.arraycopy(arguments.toArray(), 0, argsWithToken, 1, arguments.size());
                return DefaultHostXmlRpcClient.this.invoke(serviceName + "." + methodName, Object.class, argsWithToken);
            }
        });
        return (T)Proxy.newProxyInstance((ClassLoader)new ChainingClassLoader(new ClassLoader[]{this.getClass().getClassLoader(), bindClass.getClassLoader()}), new Class[]{bindClass}, (InvocationHandler)handler);
    }

    @Override
    public <T> Promise<T> invoke(String method, Class<T> resultType, Object ... arguments) {
        StringWriter writer = new StringWriter(2048);
        this.beginCall(writer, method);
        FaultHandlingXmlRpcParser parser = new FaultHandlingXmlRpcParser();
        for (Object argument : arguments) {
            try {
                ((Writer)writer).write("<param>");
                this.serializer.serialize(argument, writer);
                ((Writer)writer).write("</param>");
            }
            catch (IOException ioe) {
                throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), ioe);
            }
        }
        return this.endCall(writer, parser, resultType);
    }

    private void beginCall(Writer writer, String methodName) throws XmlRpcException {
        try {
            ((StringWriter)writer).getBuffer().setLength(0);
            writer.write("<?xml version=\"1.0\" encoding=\"");
            writer.write(XmlRpcMessages.getString("XmlRpcClient.Encoding"));
            writer.write("\"?>");
            writer.write("<methodCall><methodName>");
            writer.write(methodName);
            writer.write("</methodName><params>");
        }
        catch (IOException ioe) {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.NetworkError"), ioe);
        }
    }

    @VisibleForTesting
    <T> Promise<T> endCall(Writer writer, final FaultHandlingXmlRpcParser parser, final Class<T> castResultTo) {
        try {
            writer.write("</params>");
            writer.write("</methodCall>");
            return this.httpClient.newRequest(serverXmlRpcPath).setContentType("text/xml").setContentCharset(XmlRpcMessages.getString("XmlRpcClient.Encoding")).setEntity(writer.toString()).post().transform().ok(new Function<Response, T>(){

                public T apply(Response response) {
                    return DefaultHostXmlRpcClient.this.parseResponse(parser, response, castResultTo);
                }
            }).others(ResponsePromises.newUnexpectedResponseFunction()).toPromise();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Should never happen", ioe);
        }
    }

    private <T> T parseResponse(final FaultHandlingXmlRpcParser parser, final Response response, final Class<T> castResultTo) {
        try {
            return (T)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)this.getClass().getClassLoader(), (Callable)new Callable<T>(){

                @Override
                public T call() {
                    try {
                        parser.parse(new BufferedInputStream(response.getEntityStream()));
                    }
                    catch (Exception e) {
                        throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcClient.ParseError"), e);
                    }
                    if (parser.isFaultResponse()) {
                        XmlRpcStruct fault = (XmlRpcStruct)parser.getParsedValue();
                        throw new XmlRpcFault(fault.getInteger("faultCode"), fault.getString("faultString"));
                    }
                    Object parsedValue = parser.getParsedValue();
                    if (parsedValue != null && castResultTo.isAssignableFrom(parsedValue.getClass())) {
                        return castResultTo.cast(parsedValue);
                    }
                    throw new XmlRpcException("Unexpected return type: '" + parsedValue.getClass().getName() + "', expected: '" + castResultTo.getName() + "'");
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never happen", e);
        }
    }
}

