/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import com.google.inject.AbstractModule;
import org.ops4j.peaberry.BundleScoped;
import org.ops4j.peaberry.ServiceRegistry;
import org.ops4j.peaberry.cache.CachingServiceRegistry;
import org.ops4j.peaberry.cache.Chain;
import org.ops4j.peaberry.cache.RegistryChain;
import org.ops4j.peaberry.osgi.BundleScopeImpl;
import org.ops4j.peaberry.osgi.OSGiServiceRegistry;
import org.osgi.framework.BundleContext;

public final class OSGiModule
extends AbstractModule {
    private final BundleContext bundleContext;
    private final ServiceRegistry[] registries;

    public OSGiModule(BundleContext bundleContext, ServiceRegistry ... registries) {
        if (null == bundleContext) {
            throw new IllegalArgumentException("null bundle context");
        }
        this.bundleContext = bundleContext;
        this.registries = registries;
    }

    public OSGiModule(ServiceRegistry ... registries) {
        this.bundleContext = null;
        this.registries = registries;
    }

    protected void configure() {
        if (this.bundleContext != null) {
            this.bind(BundleContext.class).toInstance(this.bundleContext);
        }
        this.bindScope(BundleScoped.class, new BundleScopeImpl(this.getProvider(BundleContext.class)));
        if (this.registries.length == 0) {
            this.bind(ServiceRegistry.class).to(CachingServiceRegistry.class);
        } else {
            this.bind(ServiceRegistry.class).annotatedWith(Chain.class).to(CachingServiceRegistry.class);
            this.bind(ServiceRegistry[].class).annotatedWith(Chain.class).toInstance(this.registries);
            this.bind(ServiceRegistry.class).to(RegistryChain.class);
        }
        this.bind(CachingServiceRegistry.class).to(OSGiServiceRegistry.class).in(BundleScoped.class);
    }
}

