/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.webpanel.extractor;

import com.atlassian.plugin.remotable.plugin.module.webpanel.extractor.WebPanelParameterExtractor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebPanelURLParametersSerializer {
    private final List<WebPanelParameterExtractor> webPanelParameterExtractors;

    public WebPanelURLParametersSerializer() {
        this(Collections.emptyList());
    }

    @Autowired(required=false)
    public WebPanelURLParametersSerializer(List<WebPanelParameterExtractor> webPanelParameterExtractors) {
        this.webPanelParameterExtractors = (List)Preconditions.checkNotNull(webPanelParameterExtractors);
    }

    public ImmutableMap<String, String[]> getExtractedWebPanelParameters(Map<String, Object> context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WebPanelParameterExtractor extractor : this.webPanelParameterExtractors) {
            Optional<Map.Entry<String, String[]>> extractedParameters = extractor.extract(context);
            if (!extractedParameters.isPresent()) continue;
            builder.put(((Map.Entry)extractedParameters.get()).getKey(), ((Map.Entry)extractedParameters.get()).getValue());
        }
        return builder.build();
    }
}

