/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.CannotDisable;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.plugin.OAuthLinkManager;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.plugin.util.RemotePluginUtil;
import com.atlassian.plugin.remotable.spi.applinks.RemotePluginContainerApplicationType;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.List;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CannotDisable
public final class RemotePluginContainerModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    public static final String PLUGIN_KEY_PROPERTY = "plugin-key";
    private final MutatingApplicationLinkService applicationLinkService;
    private final OAuthLinkManager oAuthLinkManager;
    private final PermissionManager permissionManager;
    private final TypeAccessor typeAccessor;
    private final BundleContext bundleContext;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Logger log = LoggerFactory.getLogger(RemotePluginContainerModuleDescriptor.class);
    private URI displayUrl;
    private Element oauthElement;
    private ApplicationLinkDetails applicationLinkDetails;
    private boolean remoteMode;
    private Bundle pluginBundle;

    public RemotePluginContainerModuleDescriptor(ModuleFactory moduleFactory, MutatingApplicationLinkService applicationLinkService, OAuthLinkManager oAuthLinkManager, PermissionManager permissionManager, TypeAccessor typeAccessor, BundleContext bundleContext, PluginSettingsFactory pluginSettingsFactory) {
        super(moduleFactory);
        this.applicationLinkService = (MutatingApplicationLinkService)Preconditions.checkNotNull((Object)applicationLinkService);
        this.oAuthLinkManager = (OAuthLinkManager)Preconditions.checkNotNull((Object)oAuthLinkManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.typeAccessor = (TypeAccessor)Preconditions.checkNotNull((Object)typeAccessor);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.oauthElement = element.element("oauth");
        this.displayUrl = Dom4jUtils.getRequiredUriAttribute(element, "display-url");
        this.applicationLinkDetails = ApplicationLinkDetails.builder().displayUrl(this.displayUrl).isPrimary(false).name(plugin.getName() != null ? plugin.getName() : plugin.getKey()).rpcUrl(this.displayUrl).build();
        if (element.getParent().elements(element.getName()).size() > 1) {
            throw new PluginParseException("Can only have one remote-plugin-container module in a descriptor");
        }
        this.remoteMode = RemotePluginUtil.isRemoteMode(BundleUtil.findBundleForPlugin(this.bundleContext, plugin.getKey()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enabled() {
        this.pluginBundle = BundleUtil.findBundleForPlugin(this.bundleContext, this.getPluginKey());
        if (this.remoteMode) {
            ApplicationId expectedApplicationId = ApplicationIdUtil.generate((URI)this.displayUrl);
            MutableApplicationLink link = null;
            RemotePluginContainerApplicationType applicationType = (RemotePluginContainerApplicationType)this.typeAccessor.getApplicationType(RemotePluginContainerApplicationType.class);
            try {
                link = this.applicationLinkService.getApplicationLink(expectedApplicationId);
            }
            catch (TypeNotInstalledException ex) {
                log.info("Link found for '{}' but the type cannot be found, treating as not found", (Object)this.getPluginKey());
                this.manuallyDeleteApplicationId(expectedApplicationId);
            }
            if (link != null) {
                if (!this.getPluginKey().equals(link.getProperty(PLUGIN_KEY_PROPERTY))) throw new PluginParseException("Application link already exists for id '" + expectedApplicationId + "' but it isn't the target " + " plugin '" + this.getPluginKey() + "': unexpected plugin key is: " + link.getProperty(PLUGIN_KEY_PROPERTY));
                log.info("Application link for remote plugin container '{}' already exists", (Object)this.getPluginKey());
            } else {
                for (ApplicationLink otherLink : this.applicationLinkService.getApplicationLinks(RemotePluginContainerApplicationType.class)) {
                    if (!this.getPluginKey().equals(otherLink.getProperty(PLUGIN_KEY_PROPERTY))) continue;
                    log.debug("Old application link for this plugin '{}' found with different display url '{}', removing", (Object)this.getPluginKey(), (Object)this.displayUrl);
                    this.applicationLinkService.deleteApplicationLink(otherLink);
                }
                log.info("Creating an application link for the remote plugin container of key '{}'", (Object)this.getPluginKey());
                link = this.applicationLinkService.addApplicationLink(expectedApplicationId, (ApplicationType)applicationType, this.applicationLinkDetails);
                link.putProperty(PLUGIN_KEY_PROPERTY, (Object)this.getPluginKey());
            }
            link.putProperty("IS_ACTIVITY_ITEM_PROVIDER", (Object)Boolean.FALSE.toString());
            link.putProperty("system", (Object)Boolean.TRUE.toString());
            ServiceProvider serviceProvider = this.createOAuthServiceProvider(this.displayUrl, this.oauthElement);
            this.oAuthLinkManager.associateProviderWithLink((ApplicationLink)link, applicationType.getId().get(), serviceProvider);
            if (this.oauthElement != null) {
                this.registerOAuth((ApplicationLink)link, this.oauthElement);
            }
        } else {
            log.info("Plugin '{}' in local mode, so not setting up remote plugin container link", (Object)this.getPluginKey());
        }
        super.enabled();
    }

    private void manuallyDeleteApplicationId(ApplicationId expectedApplicationId) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        List applicationIds = (List)pluginSettings.get("applinks.global.application.ids");
        if (applicationIds != null) {
            if (!applicationIds.remove(expectedApplicationId.get())) {
                throw new IllegalStateException("Cannot find application id " + expectedApplicationId.get() + " to delete");
            }
        } else {
            throw new IllegalStateException("Cannot find application ids to manually delete " + expectedApplicationId.get());
        }
        pluginSettings.put("applinks.global.application.ids", (Object)applicationIds);
    }

    public void disabled() {
        super.disabled();
        if (this.remoteMode && this.pluginBundle != null) {
            MutatingApplicationLinkService applicationLinkService = this.getService(MutatingApplicationLinkService.class);
            for (ApplicationLink link : applicationLinkService.getApplicationLinks()) {
                if (!this.displayUrl.equals(link.getRpcUrl())) continue;
                log.info("Removing application link for display url '{}'", (Object)this.displayUrl);
                applicationLinkService.deleteApplicationLink(link);
            }
            ServiceProviderConsumerStore store = this.getService(ServiceProviderConsumerStore.class);
            if (store.get(this.getPluginKey()) != null) {
                store.remove(this.getPluginKey());
            }
        }
    }

    private ServiceProvider createOAuthServiceProvider(URI displayUrl, Element oauthElement) {
        if (oauthElement != null) {
            URI requestTokenUrl = URI.create(displayUrl + Dom4jUtils.getOptionalAttribute(oauthElement, "request-token-url", "/request-token"));
            URI accessTokenUrl = URI.create(displayUrl + Dom4jUtils.getOptionalAttribute(oauthElement, "access-token-url", "/access-token"));
            URI authorizeUrl = URI.create(displayUrl + Dom4jUtils.getOptionalAttribute(oauthElement, "authorize-url", "/authorize"));
            return new ServiceProvider(requestTokenUrl, accessTokenUrl, authorizeUrl);
        }
        URI dummyUri = URI.create("http://localhost");
        return new ServiceProvider(dummyUri, dummyUri, dummyUri);
    }

    private void registerOAuth(ApplicationLink link, Element oauthElement) {
        this.permissionManager.requirePermission(this.getPluginKey(), "create_oauth_link");
        PluginInformation pluginInfo = this.getPlugin().getPluginInformation();
        String name = this.getPlugin().getName();
        String description = pluginInfo.getDescription();
        URI callback = URI.create(this.displayUrl + Dom4jUtils.getOptionalAttribute(oauthElement, "callback", "/callback"));
        PublicKey publicKey = this.getPublicKey(Dom4jUtils.getRequiredElementText(oauthElement, "public-key"));
        Consumer consumer = Consumer.key((String)this.getPluginKey()).name(name != null ? name : this.getPluginKey()).publicKey(publicKey).description(description).callback(callback).build();
        this.oAuthLinkManager.associateConsumerWithLink(link, consumer);
    }

    protected final PublicKey getPublicKey(String publicKeyText) {
        PublicKey publicKey;
        try {
            publicKey = publicKeyText.startsWith("-----BEGIN CERTIFICATE-----") ? RSAKeys.fromEncodedCertificateToPublicKey((String)publicKeyText) : RSAKeys.fromPemEncodingToPublicKey((String)publicKeyText);
        }
        catch (GeneralSecurityException e) {
            throw new PluginParseException("Invalid public key", (Throwable)e);
        }
        return publicKey;
    }

    private <T> T getService(Class<T> interfaceClass) {
        if (this.pluginBundle != null) {
            return OsgiServiceUtils.getService(this.pluginBundle.getBundleContext(), interfaceClass);
        }
        throw new IllegalStateException("Cannot retrieve services from unknown plugin bundle: " + this.getCompleteKey());
    }

    public Void getModule() {
        return null;
    }
}

