/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.httpclient.api.ForwardingHttpClient;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.spi.ThreadLocalContextManager;
import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.api.service.http.HostHttpClient;
import com.atlassian.plugin.remotable.host.common.service.http.DefaultRequestContext;
import com.atlassian.plugin.remotable.host.common.util.ServicePromise;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.concurrent.Callable;

public final class DefaultHostHttpClient
extends ForwardingHttpClient
implements HostHttpClient {
    private final HttpClient httpClient;
    private final DefaultRequestContext requestContext;

    public DefaultHostHttpClient(Promise<HttpClientFactory> httpClientFactoryPromise, final DefaultRequestContext requestContext, final SignedRequestHandler signedRequestHandler, final ThreadLocalContextManager threadLocalContextManager) {
        this.requestContext = (DefaultRequestContext)Preconditions.checkNotNull((Object)requestContext);
        this.httpClient = ServicePromise.promiseProxy(httpClientFactoryPromise.map((Function)new Function<HttpClientFactory, HttpClient>(){

            public HttpClient apply(HttpClientFactory httpClientFactory) {
                return httpClientFactory.create(DefaultHostHttpClient.this.getHttpOptions(requestContext, (SignedRequestHandler)Preconditions.checkNotNull((Object)signedRequestHandler)), new DefaultHostHttpClientThreadLocalContextManager(threadLocalContextManager));
            }
        }), HttpClient.class);
    }

    protected HttpClient delegate() {
        return this.httpClient;
    }

    private HttpClientOptions getHttpOptions(DefaultRequestContext requestContext, SignedRequestHandler signedRequestHandler) {
        HttpClientOptions options = new HttpClientOptions();
        options.setThreadPrefix("hostclient");
        options.setRequestPreparer((Effect)new HostHttpClientRequestPreparer(requestContext, signedRequestHandler));
        return options;
    }

    @Override
    public <T> T callAs(String clientKey, String userId, Callable<T> callable) {
        String oldClientKey = this.requestContext.getClientKey();
        String oldUserId = this.requestContext.getUserId();
        try {
            this.requestContext.setClientKey(clientKey);
            this.requestContext.setUserId(userId);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            this.requestContext.setClientKey(oldClientKey);
            this.requestContext.setUserId(oldUserId);
        }
    }

    private static final class DefaultHostHttpClientThreadLocalContextManager<C>
    implements ThreadLocalContextManager<Pair<DefaultRequestContext.RequestData, Option<C>>> {
        private final ThreadLocalContextManager<C> threadLocalContextManager;

        private DefaultHostHttpClientThreadLocalContextManager(ThreadLocalContextManager<C> threadLocalContextManager) {
            this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull(threadLocalContextManager);
        }

        public Pair<DefaultRequestContext.RequestData, Option<C>> getThreadLocalContext() {
            return Pair.pair((Object)DefaultRequestContext.getRequestData(), (Object)Option.option((Object)this.threadLocalContextManager.getThreadLocalContext()));
        }

        public void setThreadLocalContext(Pair<DefaultRequestContext.RequestData, Option<C>> context) {
            DefaultRequestContext.setRequestData((DefaultRequestContext.RequestData)context.left());
            this.threadLocalContextManager.setThreadLocalContext(((Option)context.right()).getOrNull());
        }

        public void resetThreadLocalContext() {
            DefaultRequestContext.clear();
            this.threadLocalContextManager.resetThreadLocalContext();
        }
    }

    private static final class HostHttpClientRequestPreparer
    implements Effect<Request> {
        private final RequestContext requestContext;
        private final SignedRequestHandler signedRequestHandler;

        private HostHttpClientRequestPreparer(RequestContext requestContext, SignedRequestHandler signedRequestHandler) {
            this.requestContext = (RequestContext)Preconditions.checkNotNull((Object)requestContext);
            this.signedRequestHandler = (SignedRequestHandler)Preconditions.checkNotNull((Object)signedRequestHandler);
        }

        public void apply(Request request) {
            if (request.getUri().toString().matches("^[\\w]+:.*")) {
                throw new IllegalStateException("Absolute request URIs are not supported for host requests");
            }
            String clientKey = this.requestContext.getClientKey();
            if (clientKey == null) {
                throw new IllegalStateException("Unable to execute host http request without client key");
            }
            String baseUrl = this.signedRequestHandler.getHostBaseUrl(clientKey);
            String origUriStr = baseUrl + request.getUri();
            StringBuilder uriBuf = new StringBuilder(origUriStr);
            String userId = this.requestContext.getUserId();
            if (userId != null) {
                try {
                    uriBuf.append(uriBuf.indexOf("?") > 0 ? (char)'&' : '?').append("user_id").append('=').append(URLEncoder.encode(userId, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            request.setUri(URI.create(uriBuf.toString()));
            Request.Method method = request.getMethod();
            String authHeader = this.signedRequestHandler.getAuthorizationHeaderValue(URI.create(origUriStr), method.name(), userId);
            request.setHeader("Authorization", authHeader).setAttribute("purpose", "host-request").setAttribute("clientKey", clientKey);
        }
    }
}

