/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service;

import com.atlassian.plugin.remotable.api.service.RenderContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipeManager;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.ConsumableBigPipe;
import com.atlassian.plugin.remotable.host.common.service.AuthenticationInfo;
import com.atlassian.plugin.remotable.host.common.service.http.DefaultRequestContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.google.common.base.Function;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefaultRenderContext
implements RenderContext {
    public static final String HOST_RESOURCE_PATH = "/remotable-plugins";
    private final boolean devMode = Boolean.getBoolean("atlassian.dev.mode");
    private DefaultRequestContext requestContext;
    private SignedRequestHandler signedRequestHandler;
    private final LocaleResolver localeResolver;
    private final I18nResolver i18nResolver;
    private final BigPipeManager bigPipeManager;

    public DefaultRenderContext(DefaultRequestContext requestContext, SignedRequestHandler signedRequestHandler, LocaleResolver localeResolver, I18nResolver i18nResolver, BigPipeManager bigPipeManager) {
        this.requestContext = requestContext;
        this.signedRequestHandler = signedRequestHandler;
        this.localeResolver = localeResolver;
        this.i18nResolver = i18nResolver;
        this.bigPipeManager = bigPipeManager;
    }

    @Override
    public String getLocalBaseUrl() {
        return this.signedRequestHandler.getLocalBaseUrl();
    }

    @Override
    public String getHostContextPath() {
        String url = this.getHostBaseUrl();
        return url != null ? URI.create(url).getPath() : null;
    }

    @Override
    public String getHostBaseUrl() {
        return this.requestContext.getHostBaseUrl();
    }

    @Override
    public String getHostBaseResourceUrl() {
        String url = this.getHostBaseUrl();
        return url != null ? url + HOST_RESOURCE_PATH : null;
    }

    @Override
    public String getHostStylesheetUrl() {
        return this.getHostResourceUrl("all", "css");
    }

    @Override
    public String getHostScriptUrl() {
        return this.getHostResourceUrl("all", "js");
    }

    @Override
    public String getClientKey() {
        return this.requestContext.getClientKey();
    }

    @Override
    public String getUserId() {
        return this.requestContext.getUserId();
    }

    @Override
    public String getAuthState() {
        return AuthenticationInfo.encode(new AuthenticationInfo(this.getClientKey(), this.getUserId()));
    }

    @Override
    public String getBigPipeRequestId() {
        return (String)this.bigPipeManager.getConsumableBigPipe().map((Function)new Function<ConsumableBigPipe, String>(){

            public String apply(ConsumableBigPipe input) {
                return input.getRequestId();
            }
        }).getOrNull();
    }

    @Override
    public boolean getBigPipeActivated() {
        return !this.bigPipeManager.getConsumableBigPipe().isEmpty();
    }

    @Override
    public Locale getLocale() {
        return this.localeResolver.getLocale(this.requestContext.getRequest());
    }

    @Override
    public I18nResolver getI18n() {
        return this.i18nResolver;
    }

    @Override
    public Map<String, Object> toContextMap() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(){
            {
                this.put("localBaseUrl", DefaultRenderContext.this.getLocalBaseUrl());
                this.put("hostContextPath", DefaultRenderContext.this.getHostContextPath());
                this.put("hostBaseUrl", DefaultRenderContext.this.getHostBaseUrl());
                this.put("hostBaseResourceUrl", DefaultRenderContext.this.getHostBaseResourceUrl());
                this.put("hostStylesheetUrl", DefaultRenderContext.this.getHostStylesheetUrl());
                this.put("hostScriptUrl", DefaultRenderContext.this.getHostScriptUrl());
                this.put("userId", DefaultRenderContext.this.getUserId());
                this.put("clientKey", DefaultRenderContext.this.getClientKey());
                this.put("authState", DefaultRenderContext.this.getAuthState());
                this.put("bigPipeRequestId", DefaultRenderContext.this.getBigPipeRequestId());
                this.put("bigPipeActivated", DefaultRenderContext.this.getBigPipeActivated());
                this.put("locale", DefaultRenderContext.this.getLocale());
                this.put("i18n", DefaultRenderContext.this.getI18n());
            }
        });
    }

    private String getHostResourceUrl(String name, String ext) {
        String url = this.getHostBaseResourceUrl();
        return url != null ? url + "/" + name + (this.devMode ? "-debug" : "") + "." + ext : null;
    }
}

