/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.plugin.module.ContainerAccessor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class GuiceContainerAccessor
implements ContainerAccessor {
    private final Injector injector;

    public GuiceContainerAccessor(Injector injector) {
        this.injector = injector;
    }

    public <T> T createBean(Class<T> tClass) {
        return this.injector.getInstance(tClass);
    }

    public <T> T injectBean(T bean) {
        this.injector.injectMembers(bean);
        return bean;
    }

    public <T> T getBean(String id) {
        return (T)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named("annotation")));
    }

    public <T> Collection<T> getBeansOfType(final Class<T> tClass) {
        return Collections2.transform((Collection)Collections2.filter(this.injector.getAllBindings().entrySet(), (Predicate)new Predicate<Map.Entry<Key<?>, Binding<?>>>(){

            public boolean apply(@Nullable Map.Entry<Key<?>, Binding<?>> input) {
                return tClass.isAssignableFrom(input.getKey().getTypeLiteral().getRawType());
            }
        }), (Function)new Function<Map.Entry<Key<?>, Binding<?>>, T>(){

            public T apply(@Nullable Map.Entry<Key<?>, Binding<?>> input) {
                return input.getValue().getProvider().get();
            }
        });
    }
}

