/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.rest;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Strings;
import java.security.Key;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/oauth")
public class OAuthResource {
    private final ConsumerService consumerService;

    public OAuthResource(ConsumerService consumerService) {
        this.consumerService = consumerService;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getOauthInfo() throws JSONException {
        Consumer consumer = this.consumerService.getConsumer();
        return Response.ok((Object)new JSONObject().put("key", (Object)Strings.nullToEmpty((String)consumer.getKey())).put("name", (Object)Strings.nullToEmpty((String)consumer.getName())).put("publicKey", (Object)Strings.nullToEmpty((String)RSAKeys.toPemEncoding((Key)consumer.getPublicKey()))).put("description", (Object)Strings.nullToEmpty((String)consumer.getDescription())).toString(2)).build();
    }
}

