/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.refapp;

import com.atlassian.mail.Email;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.spi.module.UserIsAdminCondition;
import com.atlassian.plugin.remotable.spi.module.UserIsLoggedInCondition;
import com.atlassian.plugin.remotable.spi.module.UserIsSysAdminCondition;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.DefaultWebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RefappProductAccessor
implements ProductAccessor {
    private static final Logger log = LoggerFactory.getLogger(RefappProductAccessor.class);
    private final BundleContext bundleContext;

    public RefappProductAccessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public WebItemModuleDescriptor createWebItemModuleDescriptor() {
        return new DefaultWebItemModuleDescriptor(OsgiServiceUtils.getService(this.bundleContext, WebInterfaceManager.class));
    }

    @Override
    public String getPreferredAdminSectionKey() {
        return "system.admin/general";
    }

    @Override
    public int getPreferredAdminWeight() {
        return 10;
    }

    @Override
    public String getKey() {
        return "refapp";
    }

    @Override
    public int getPreferredGeneralWeight() {
        return 100;
    }

    @Override
    public String getPreferredGeneralSectionKey() {
        return "index.links";
    }

    @Override
    public int getPreferredProfileWeight() {
        return 100;
    }

    @Override
    public String getPreferredProfileSectionKey() {
        return "system.admin/general";
    }

    @Override
    public Map<String, String> getLinkContextParams() {
        return Collections.emptyMap();
    }

    @Override
    public void sendEmail(String userName, Email originalEmail, String bodyAsHtml, String bodyAsText) {
        org.apache.commons.mail.Email email = new SimpleEmail();
        try {
            if ("betty".equals(userName)) {
                email = new HtmlEmail();
                ((HtmlEmail)email).setHtmlMsg(bodyAsHtml);
                ((HtmlEmail)email).setTextMsg(bodyAsText);
            } else {
                email.setMsg(bodyAsText);
            }
            email.setHostName("localhost");
            email.setSmtpPort(2525);
            email.setFrom(originalEmail.getFrom(), originalEmail.getFromName());
            email.setSubject("[test] " + originalEmail.getSubject());
            email.addTo(originalEmail.getTo());
            final org.apache.commons.mail.Email finalEmail = email;
            ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)Email.class.getClassLoader(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        finalEmail.send();
                    }
                    catch (EmailException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof EmailException) {
                this.handleError(email, (EmailException)e.getCause());
            }
            throw e;
        }
        catch (EmailException e) {
            this.handleError(email, e);
        }
    }

    private void handleError(org.apache.commons.mail.Email email, EmailException e) {
        log.error("Unable to send email", (Throwable)e);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                email.getMimeMessage().writeTo((OutputStream)bout);
                log.debug("Sent email:\n" + new String(bout.toByteArray()));
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    @Override
    public void flushEmail() {
    }

    @Override
    public Map<String, Class<? extends Condition>> getConditions() {
        HashMap conditions = Maps.newHashMap();
        conditions.put("user_is_sysadmin", UserIsSysAdminCondition.class);
        conditions.put("user_is_logged_in", UserIsLoggedInCondition.class);
        conditions.put("user_is_admin", UserIsAdminCondition.class);
        return conditions;
    }
}

