/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.webpanel;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.plugin.remotable.plugin.module.webpanel.extractor.WebPanelURLParametersSerializer;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.remotable.spi.module.IFrameRenderer;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFrameRemoteWebPanel
implements WebPanel {
    private static final Logger log = LoggerFactory.getLogger(IFrameRemoteWebPanel.class);
    private final IFrameRenderer iFrameRenderer;
    private final IFrameContext iFrameContext;
    private final WebPanelURLParametersSerializer webPanelURLParametersSerializer;
    private final UserManager userManager;
    private final Condition condition;

    public IFrameRemoteWebPanel(IFrameRenderer iFrameRenderer, IFrameContext iFrameContext, Condition condition, WebPanelURLParametersSerializer webPanelURLParametersSerializer, UserManager userManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.webPanelURLParametersSerializer = (WebPanelURLParametersSerializer)Preconditions.checkNotNull((Object)webPanelURLParametersSerializer);
        this.iFrameRenderer = (IFrameRenderer)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.iFrameContext = (IFrameContext)Preconditions.checkNotNull((Object)iFrameContext);
        this.condition = (Condition)Preconditions.checkNotNull((Object)condition);
    }

    public String getHtml(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            this.writeHtml(writer, context);
        }
        catch (IOException e) {
            writer.write("Unable to render panel: " + e.getMessage());
            log.error("Error rendering panel", (Throwable)e);
        }
        return writer.toString();
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        if (this.condition.shouldDisplay(context)) {
            String remoteUser = StringUtils.defaultString((String)this.userManager.getRemoteUsername());
            ImmutableMap<String, String[]> params = this.webPanelURLParametersSerializer.getExtractedWebPanelParameters(context);
            writer.write(this.iFrameRenderer.render(this.iFrameContext, "", (Map<String, String[]>)params, remoteUser));
        } else {
            writer.write("Unauthorized to view this panel");
            log.error("Unauthorized view of panel");
        }
    }
}

