/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.projecttab;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.JiraTabConditionContext;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.web.Condition;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFrameProjectTab
implements ProjectTabPanel {
    private final IFrameRendererImpl iFrameRenderer;
    private final Condition condition;
    private final IFrameContext iFrameContext;
    private static final Logger log = LoggerFactory.getLogger(IFrameProjectTab.class);

    public IFrameProjectTab(IFrameContext iFrameContext, IFrameRendererImpl iFrameRenderer, Condition condition) {
        this.iFrameContext = iFrameContext;
        this.iFrameRenderer = iFrameRenderer;
        this.condition = condition;
    }

    public void init(ProjectTabPanelModuleDescriptor projectTabPanelModuleDescriptor) {
    }

    public String getHtml(BrowseContext browseContext) {
        StringWriter writer = new StringWriter();
        try {
            HashMap extraParams = Maps.newHashMap();
            extraParams.put("ctx_project_key", new String[]{browseContext.getContextKey()});
            extraParams.put("ctx_project_id", new String[]{String.valueOf(browseContext.getProject().getId())});
            String remoteUser = this.getRemoteUserName(browseContext);
            writer.write(this.iFrameRenderer.render(this.iFrameContext, "", extraParams, remoteUser));
        }
        catch (IOException e) {
            log.error("Error rendering tab", (Throwable)e);
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private String getRemoteUserName(BrowseContext browseContext) {
        return browseContext.getUser() != null ? browseContext.getUser().getName() : null;
    }

    public boolean showPanel(BrowseContext browseContext) {
        return this.condition == null || this.condition.shouldDisplay(JiraTabConditionContext.createConditionContext(browseContext));
    }
}

